% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/019_minp_uni_ln.R
\name{minp_uni_ln}
\alias{minp_uni_ln}
\alias{minp_uni_ln.default}
\alias{minp_uni_ln.formula}
\title{Minority-proportional uniform label noise}
\usage{
\method{minp_uni_ln}{default}(x, y, level, sortid = TRUE, ...)

\method{minp_uni_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Minority-proportional uniform label noise} into a classification dataset.
}
\details{
Given a dataset, assume the original class distribution of class \emph{i} is 
\emph{p}i and the distribution of the minority class is \emph{p}m. 
Let \code{level} be the noise level, \emph{Minority-proportional uniform label noise} introduces 
noise proportionally to different classes, where a sample with its label \emph{i} has a probability 
(\emph{p}m/\emph{p}i)·\code{level} to be corrupted as another random class. That is, 
the least common class is used as the baseline for noise introduction.
}
\note{
Noise model adapted from the papers in References.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- minp_uni_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], level = 0.1)

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- minp_uni_ln(formula = Species ~ ., data = iris2D, level = 0.1)

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
X. Zhu and X. Wu. 
\strong{Cost-guided class noise handling for effective cost-sensitive learning}. 
In \emph{Proc. 4th IEEE International Conference on Data Mining}, pages 297–304, 2004.
\doi{10.1109/ICDM.2004.10108}.
}
\seealso{
\code{\link{asy_uni_ln}}, \code{\link{maj_udir_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
