% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/015_lap_bor_ln.R
\name{lap_bor_ln}
\alias{lap_bor_ln}
\alias{lap_bor_ln.default}
\alias{lap_bor_ln.formula}
\title{Laplace borderline label noise}
\usage{
\method{lap_bor_ln}{default}(x, y, level, mu = 0, b = 1, k = 1, sortid = TRUE, ...)

\method{lap_bor_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{mu}{a double with the location for the Laplace distribution (default: 0).}

\item{b}{a double with the scale for the Laplace distribution (default: 1).}

\item{k}{an integer with the number of nearest neighbors to be used (default: 1).}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Laplace borderline label noise} into a classification dataset.
}
\details{
\emph{Laplace borderline label noise} uses uses an SVM to induce the decision border 
in the dataset. For each sample, its distance
to the decision border is computed. Then,
a Laplace distribution with parameters (\code{mu}, \code{b}) is used to compute the
value for the probability density function associated to each distance. Finally, 
(\code{level}·100)\% of the samples in the dataset are randomly selected to be mislabeled
according to their values of the probability density function. For each noisy sample, the 
majority class among its \code{k}-nearest neighbors of a different class 
is chosen as the new label.
}
\note{
Noise model adapted from the papers in References to multiclass data, considering SVM with linear 
kernel as classifier, a mislabeling process using the neighborhood of noisy samples and a 
noise level to control the number of errors in the data.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- lap_bor_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], level = 0.1)

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- lap_bor_ln(formula = Species ~ ., data = iris2D, level = 0.1)

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
J. Du and Z. Cai. 
\strong{Modelling class noise with symmetric and asymmetric distributions}. 
In \emph{Proc. 29th AAAI Conference on Artificial Intelligence}, pages 2589-2595, 2015.
url:\url{https://dl.acm.org/doi/10.5555/2886521.2886681}.
}
\seealso{
\code{\link{ugau_bor_ln}}, \code{\link{gaum_bor_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
