% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/007_exps_cuni_ln.R
\name{exps_cuni_ln}
\alias{exps_cuni_ln}
\alias{exps_cuni_ln.default}
\alias{exps_cuni_ln.formula}
\title{Exponential/smudge completely-uniform label noise}
\usage{
\method{exps_cuni_ln}{default}(x, y, level, sortid = TRUE, ...)

\method{exps_cuni_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the lambda value.}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Exponential/smudge completely-uniform label noise} into a classification dataset.
}
\details{
\emph{Exponential/smudge completely-uniform label noise} includes an additional attribute (\emph{smudge}) in the dataset with 
random values in [0,1]. This attribute is used to compute the mislabeling probability for each sample
based on an exponential function (in which \code{level} is used as lambda). It selects samples
in the dataset based on these probabilities. Finally, the labels of these samples are 
randomly replaced by others within the set of class labels (this model can choose the original 
label of a sample as noisy).
}
\note{
Noise model adapted from the papers in References.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- exps_cuni_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], level = 0.8)

# show results
summary(outdef, showid = TRUE)
plot(outdef, pca = TRUE)

# usage of the method for class formula
set.seed(9)
outfrm <- exps_cuni_ln(formula = Species ~ ., data = iris2D, level = 0.8)

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
B. Denham, R. Pears, and M. A. Naeem. 
\strong{Null-labelling: A generic approach for learning in the presence of class noise}. 
In \emph{Proc. 20th IEEE International Conference on Data Mining}, pages 990–995, 2020.
\doi{10.1109/ICDM50108.2020.00114}.
}
\seealso{
\code{\link{opes_idu_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
