% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uscrime.R
\docType{data}
\name{uscrime}
\alias{uscrime}
\title{U.S. Crime rates per 100,00 people}
\format{
A data frame with 50 observations on the following 8 variables.
\describe{
  \item{state}{U.S. state}
  \item{murder}{murders}
  \item{rape}{rapes}
  \item{robbery}{robbery}
  \item{assault}{assault}
  \item{burglary}{burglary}
  \item{larceny}{larceny}
  \item{autotheft}{automobile thefts}
}
}
\source{
Documentation Example 3 for PROC HPPRINCOMP.
http://documentation.sas.com/api/docsets/stathpug/14.2/content/stathpug_code_hppriex3.htm?locale=en
}
\usage{
uscrime
}
\description{
U.S. Crime rates per 100,00 people for 7 categories in each of the 50 U.S.
states in 1977.
}
\details{
There are two missing values.
}
\examples{

library(nipals)
head(uscrime)

# SAS deletes rows with missing values
dat <- uscrime[complete.cases(uscrime), ]
dat <- as.matrix(dat[ , -1])
m1 <- nipals(dat) # complete-data method

# Traditional NIPALS with missing data  
dat <- uscrime
dat <- as.matrix(dat[ , -1])
m2 <- nipals(dat, gramschmidt=FALSE) # missing 
round(crossprod(m2$loadings),3) # Prin Comps not quite orthogonal
  
# Gram-Schmidt corrected NIPALS
m3 <- nipals(dat, gramschmidt=TRUE) # TRUE is default
round(crossprod(m3$loadings),3) # Prin Comps are orthogonal

}
\references{
SAS/STAT User's Guide: High-Performance Procedures.  The HPPRINCOMP Procedure.
http://support.sas.com/documentation/cdl/en/stathpug/67524/HTML/default/viewer.htm#stathpug_hpprincomp_toc.htm
}
\keyword{datasets}
