% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_games.R
\name{nhl_url_games}
\alias{nhl_url_games}
\title{Create an NHL API URL for games}
\usage{
nhl_url_games(gameIds, element)
}
\arguments{
\item{gameIds}{\code{numeric()}, vector of one or more game ids. The
game id is a 10 digit number where the
\itemize{
\item first 4 digits identify the season of the game, for instance
2017 for the 2017-2018 season.
\item next 2 digits give the type of game, where
\itemize{
\item 01 - preseason,
\item 02 - regular season,
\item 03 - playoffs,
\item 04 - all-star.
}
\item final 4 digits identify the specific game number
\itemize{
\item for regular season and preseason games, this ranges from
0001 to the number of games played. That is 1271 for
seasons with 31 teams and 1230 for seasons with 30 teams.
\item for playoff games, the
\itemize{
\item second digit gives the round of the playoffs
\item third digit specifies the match-up
\item fourth digit specifies the game (out of 7)
}
}
}}

\item{element}{\code{character()} vector of one or more valid elements.
Currently the valid elements seem to be:
\itemize{
\item \code{"linescore"}
\item \code{"boxscore"}
\item \code{"content"}
\item \code{"feed/live"}
}}
}
\value{
\code{character()}, of same length as \code{gameIds}.
}
\description{
Create an NHL API URL for games
}
\examples{
  nhlapi:::nhl_url_games(2017010001, "content")
  nhlapi:::nhl_url_games(
    c(2017010001, 2017010002),
    c("content", "boxscore")
  )

}
