% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsep_distribution.R
\name{jsep}
\alias{jsep}
\alias{djsep}
\alias{pjsep}
\alias{qjsep}
\alias{rjsep}
\title{Jones Skew Exponential Power}
\usage{
djsep(x, mu = 0, sigma = 1, alpha = 2, beta = 2, log = FALSE)

pjsep(
  q,
  mu = 0,
  sigma = 1,
  alpha = 2,
  beta = 2,
  lower.tail = TRUE,
  log.p = FALSE
)

qjsep(
  p,
  mu = 0,
  sigma = 1,
  alpha = 2,
  beta = 2,
  lower.tail = TRUE,
  log.p = FALSE
)

rjsep(n, mu = 0, sigma = 1, alpha = 2, beta = 2)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{a location parameter.}

\item{sigma}{a scale parameter.}

\item{alpha}{a shape parameter (left tail heaviness parameter).}

\item{beta}{a shape parameter (right tail heaviness parameter).}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p)
The default value of this parameter is FALSE}

\item{lower.tail}{logical;if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise, \eqn{P\left[ X>x\right] }.}

\item{p}{vectors of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{djsep} gives the density , \code{pjsep} gives the distribution function,
\code{qjsep} gives quantiles function, \code{rjsep} generates random numbers.
}
\description{
To calculate density function, distribution function, quantile function, and  build data from random generator function 
for the Jones Skew Exponential Power
}
\details{
Jones Skew Exponential Power

The Jones Skew Exponential Power with parameters \eqn{\mu}, \eqn{\sigma},\eqn{\alpha}, and \eqn{\beta}
has density:
\deqn{
    f(y | \mu, \sigma, \alpha, \beta) = \left\{
      \begin{array}{ll}
        \frac{c}{\sigma} \exp\left(-|z|^{\alpha}\right), & \text{if } y < \mu \\
        \frac{c}{\sigma} \exp\left(-|z|^{\beta}\right), & \text{if } y \geq \mu
      \end{array}
    \right.
  }
  where:
  \deqn{z = \frac{y - \mu}{\sigma},}
  \deqn{c = \left[ \Gamma(1 + \beta^{-1}) + \Gamma(1 + \alpha^{-1}) \right]^{-1}.}
}
\examples{
djsep(4, mu=0, sigma=1, alpha=2, beta=2)
pjsep(4, mu=0, sigma=1, alpha=2, beta=2)
qjsep(0.5, mu=0, sigma=1, alpha=2, beta=2)
rjsep(4, mu=0, sigma=1, alpha=2, beta=2)
}
\references{
Rigby, R.A. and Stasinopoulos, M.D. and Heller, G.Z. and De Bastiani, F. 
  (2019) Distributions for Modeling Location, Scale, 
  and Shape: Using GAMLSS in R.CRC Press
}
\author{
Meischa Zahra Nur Adhelia
}
\concept{Continuous}
\concept{Univariate}
\keyword{distribution}
