% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assets.R
\name{earth_asset}
\alias{earth_asset}
\title{Call Asset API}
\usage{
earth_asset(key, lon, lat, start_date, end_date = Sys.Date())
}
\arguments{
\item{key}{Key for API authentication.}

\item{lon}{Longitud of coordinate position.}

\item{lat}{Latitud of coordinate position.}

\item{start_date}{Start date to search for image. In YYYY-MM-DD format.}

\item{end_date}{End date to search for image. In YYYY-MM-DD format. Defaults to current system date.}
}
\description{
Calls NASA's Earth Imagery Assets API and returns data.frame with information on time and location of images between two dates.
}
\examples{
\dontrun{
key <- "123key"
img <- earth_asset(key, -100.31008, 25.66779, "2016-01-01")
}
}

