% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_files.R
\name{data_files}
\alias{data_files}
\alias{data_dictionary}
\title{Get Study Data Files List and Data Dictionary}
\usage{
data_files(catalog, id)

data_dictionary(catalog, id, file_id = NULL)
}
\arguments{
\item{catalog}{A required character string specifying the name of the data
catalog (e.g., \code{"wb"}, \code{"fao"}). Valid codes can be found in the
documentation for \code{catalogs()}.}

\item{id}{A required study identifier. Accepts either the numeric \strong{Study ID}
(integer, e.g., \code{101}) or the character \strong{Study ID Number} (string,
e.g., \code{"ALB_2012_LSMS_v01_M_v01_A_PUF"}). These values are typically
returned in the search results from \code{search_catalog()},
\code{latest_entries()} or \code{data_files()}.}

\item{file_id}{An optional character identifier, applicable only to
\code{data_dictionary()}. This is the ID of a specific data file within the study,
typically found in the \code{file_id} column returned by \code{data_files()}.
If \code{NULL} (default), \code{data_dictionary()} attempts to fetch variables
for the entire study.}
}
\value{
The return value depends on the function called:
\itemize{
\item \code{data_files()}: A \strong{data frame} detailing the files associated with the study.
Typical columns include \code{file_name}, \code{dfile_id}, \code{file_type}, and \code{file_size}.
\item \code{data_dictionary()}: A \strong{data frame} containing the variable-level
metadata (the data dictionary). Typical columns include \code{name}, \code{label},
and \code{var_id}.
}
If the API returns no files or variables, a warning message is issued.
}
\description{
Retrieves information about the files included in a study, or the detailed
\strong{data dictionary} (variables) for the entire study or a specific data file.
}
\details{
\code{data_files()} returns the list of files available for a study, along with metadata
like file name, size, and ID.

\code{data_dictionary()} retrieves the variable-level metadata, including variable names,
labels, and definitions. If \code{file_id} is provided, it retrieves the dictionary
for that specific file; otherwise, it attempts to fetch the dictionary for the entire study.
The function automatically detects whether the provided study identifier (\code{id}) is numeric or character.
}
\examples{
\dontrun{
# Example 1: Get the list of files for a World Bank study (using idno)
study_idno <- "ALB_2012_LSMS_v01_M_v01_A_PUF"
files_wb <- data_files(catalog = "wb", id = study_idno)
print(files_wb)

# Example 2: Get the data dictionary for the entire study (using idno)
dictionary_all <- data_dictionary(catalog = "wb", id = study_idno)
head(dictionary_all)

# Example 3: Get the data dictionary for a specific file
# First, retrieve the files to find a file_id (dfile_id)
file_id_to_use <- files_wb$file_id[1] # Use the ID of the first file
dictionary_file <- data_dictionary(
  catalog = "wb",
  id = study_idno,
  file_id = file_id_to_use
)
head(dictionary_file)
}
}
\seealso{
\code{\link{search_catalog}}, \code{\link{latest_entries}}
}
\author{
Gutama Girja Urago
}
