% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_branch.R
\name{add_mutate_branch}
\alias{add_mutate_branch}
\title{Add mutate branches to a \code{mverse} object.}
\usage{
add_mutate_branch(.mverse, ...)
}
\arguments{
\item{.mverse}{a \code{mverse} object.}

\item{...}{\code{mutate_branch} objects.}
}
\value{
The resulting \code{mverse} object.
}
\description{
This method adds one or more mutate branches to
an existing \code{mverse} object. Mutate branches
are used to define options for adding a new
column to the analysis dataset.
}
\examples{
# Define mutate branches.
hurricane_strength <- mutate_branch(
  # damage vs. wind speed vs.pressure
  NDAM,
  HighestWindSpeed,
  Minpressure_Updated_2014,
  # Standardized versions
  scale(NDAM),
  scale(HighestWindSpeed),
  -scale(Minpressure_Updated_2014),
)
y <- mutate_branch(
  alldeaths, log(alldeaths + 1)
)
# Create a mverse and add the branches.
mv <- create_multiverse(hurricane) \%>\%
  add_mutate_branch(hurricane_strength) \%>\%
  add_mutate_branch(y)
# You can also add multiple branches with a single call.
mv <- create_multiverse(hurricane) \%>\%
  add_mutate_branch(hurricane_strength, y)
}
\seealso{
Other mutate branch functions: 
\code{\link{mutate_branch}}
}
\concept{mutate branch functions}
