\name{Dissimilarity between two data matrices based on the RV coefficient}
\alias{drv}
\title{
Dissimilarity between two data matrices based on the RV coefficient
}

\description{
Dissimilarity between two data matrices based on the RV coefficient.
}

\usage{
drv(y, x)
}

\arguments{
\item{y}{
A numerical matrix.
}
\item{x}{
A numerical matrix.
}
}

\details{
The dissimilarity between the two data matrices is computed as \eqn{\sqrt{2}\sqrt{1-RV(y, x)}}, where \eqn{RV(y,x)}is the RV coefficient.
}

\value{
The value of the dissimilarity.
}

\references{
Josse J., Pages J. and Husson F. (2008). Testing the significance of the RV coefficient. Computational Statistics & Data Analysis, 53(1): 82--91.
}

\author{
Michail Tsagris

R implementation and documentation: Michail Tsagris \email{mtsagris@uoc.gr}.
}

%\note{
%%  ~~further notes~~
%}

\seealso{
\code{ \link{rv}, \link{sq.correl}, \link{dcor}
}
}

\examples{
drv( as.matrix(iris[, 1:2]), as.matrix(iris[, 3:4]) )
}


