% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{fdr_summary}
\alias{fdr_summary}
\title{Calibration using Synthetic Nulls}
\usage{
fdr_summary(contrast, effect = "indirect_overall", q_value = 0.15)
}
\arguments{
\item{contrast}{A data.frame summarizing the differences between outcomes
across hypothetical treatments, typically as output by \code{null_contrast}.
Each row is one outcome in one hypothetical scenario.}

\item{effect}{Either "indirect_overall" (the default), "indirect_pathwise",
or "direct_effect" specifying the type of effect that we want to select.}

\item{q_value}{The target for false discovery rate control. The last time the
estimated FDR is above this threshold is smallest magnitude of effect size
that we will consider.}
}
\value{
fdr A data.frame specifying, for each candidate effect, whether it
should be selected.
}
\description{
This function computes a threshold for indirect or direct effect estimates
that controls the false discovery rate according to estimates made using real
and synthetic null data, against the null hypotheses that effects are zero.
It computes the proportion of synthetic null estimates that are among the top
K largest effects (in magnitude) as an estimate of the FDR.
}
\examples{
# example with null data - notice synthetic data has larger effect.
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
multimedia(exper) |>
    estimate(exper) |>
    null_contrast(exper) |>
    fdr_summary("direct_effect")

multimedia(exper) |>
    estimate(exper) |>
    null_contrast(exper, "M->Y", indirect_overall) |>
    fdr_summary("indirect_overall")

# example with another dataset - synthetic effect is smaller.
exper <- demo_spline(tau = c(2, 1)) |>
    mediation_data(starts_with("outcome"), "treatment", "mediator")
multimedia(exper) |>
    estimate(exper) |>
    null_contrast(exper) |>
    fdr_summary("direct_effect")

multimedia(exper) |>
    estimate(exper) |>
    null_contrast(exper, "M->Y", indirect_overall) |>
    fdr_summary("indirect_overall")
}
