% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup.R
\name{outcomes,multimedia-method}
\alias{outcomes,multimedia-method}
\title{Names of Outcomes in a Multimedia Object}
\usage{
\S4method{outcomes}{multimedia}(object)
}
\arguments{
\item{object}{An object of class multimedia.}
}
\value{
m A vector of strings containing the names of all the outcomes.
}
\description{
This is a helper that returns the names of the outcome variables in an
object of class multimedia. It parses the graph in the DAG specifying the
mediation analysis, and it returns all variables of node type outcome.
}
\examples{
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
multimedia(exper) |>
    outcomes()

exper <- demo_spline(tau = c(2, 1)) |>
    mediation_data(starts_with("outcome"), "treatment", "mediator")
multimedia(exper) |>
    outcomes()
}
