% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\docType{class}
\name{model-class}
\alias{model-class}
\title{Representation of an Outcome or Mediation Model}
\description{
To work with many model types simultaneously, multimedia uses a model class
with the necessary mediation model functionality that wraps any specific
implementation. The slots below define the generally required functionality
for any specific implementation.
}
\section{Slots}{

\describe{
\item{\code{estimator}}{A function that takes a formula, input data frame X, and an
response data.frame $Y$ and returns a model. For example, for the random
forest model, this is created by wrapping \code{parallelize()} on the ranger()
function for random forest estimation function using the 'ranger' package.}

\item{\code{estimates}}{A list containing the estimated model.}

\item{\code{sampler}}{A function that supports sampling new responses from the
estimated model.}

\item{\code{model_type}}{A string specifying the type of model associated with the
class. For example, "rf_model()" denotes a random forest model.}

\item{\code{predictor}}{A function that returns fitted predictions given new inputs.
For example, this can be the original predict() method for a multivariate
response model, or it can be a loop over predicts for each feature in the
mediation or outcome model.}
}}

\examples{
m <- lm_model()
estimator(m)(mpg ~ hp + wt, data = mtcars)

m <- rf_model()
estimator(m)(mpg ~ hp + wt, data = mtcars)
}
