% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{write.sqlite}
\alias{write.sqlite}
\title{Export MSThermResultSet to an SQLite database.}
\usage{
write.sqlite(res, file)
}
\arguments{
\item{res}{An MSThermResultSet object}

\item{file}{Path to the output sqlite database to be created}
}
\value{
Nothing
}
\description{
Exports and MSThermResultSet object to a new SQLite database file.
Each model (specific to a given replicate and protein) is exported as an
individual record. The schema used for the 'data' table can be seen in the
code below.
}
\examples{
control <- system.file("extdata", "demo_project/control.tsv", package="mstherm")
annots  <- system.file("extdata", "demo_project/annots.tsv",  package="mstherm")
expt    <- MSThermExperiment(control, annotations=annots)
expt    <- normalize_to_std(expt, "cRAP_ALBU_BOVIN", plot=FALSE)
res     <- model_experiment(expt, bootstrap=FALSE, np=2)

fn <- tempfile(fileext = ".sqlite")
write.sqlite(res, fn)
unlink(fn) # for example only

}
