% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{model_protein}
\alias{model_protein}
\title{Model single protein.}
\usage{
model_protein(expt, protein, min_rep_psm = 0, min_smp_psm = 0,
  min_tot_psm = 0, max_inf = 1, min_score, max_score, smooth = 0,
  method = "sum", method.denom = "near", trim = 0, bootstrap = 0,
  min_bs_psms = 8, annot_sep = "|", max_slope = 0, min_r2 = 0,
  min_reps = 0, only_modeled = 0, check_missing = 0,
  missing_cutoff = 0.3)
}
\arguments{
\item{expt}{An MSThermExperiment object}

\item{protein}{ID of the protein to model}

\item{min_rep_psm}{Minimum number of spectral matches required for each
replicate to model protein}

\item{min_smp_psm}{Minimum number of spectral matches required for each
sample to model protein}

\item{min_tot_psm}{Minimum number of spectral matches required across all
replicates to model protein}

\item{max_inf}{Maximum co-isolation interference level allowed to include a
spectrum in protein-level quantification}

\item{min_score}{minimum score allowed to include a
spectrum in protein-level quantification}

\item{max_score}{maximum score allowed to include a
spectrum in protein-level quantification}

\item{smooth}{(t/F) Perform loess smoothing on the data prior to modeling}

\item{method}{Protein quantification method to use (see Details)}

\item{method.denom}{Method used to calculate denominator of abundance
(see Details)}

\item{trim}{(t/F) Trim all lower data points less than the abundance maximum}

\item{bootstrap}{(T/F) Perform bootstrap analysis to determine confidence
intervals (slow)}

\item{min_bs_psms}{Minimum number of spectral matches required to perform
bootstrapping}

\item{annot_sep}{Symbol used to separate protein group IDs (used for
retrieval of annotations) (default: '|')}

\item{max_slope}{Maximum slope to consider model (implies "only_modeled")}

\item{min_r2}{Minimum R2 value to consider model (implies "only_modeled")}

\item{min_reps}{Minimum number of modeled replicates for each sample to
return protein}

\item{only_modeled}{(t/F) Only consider modeled proteins}

\item{check_missing}{(t/F) Run simple test to filter out PSMs with missing
quantification channels where values are expected}

\item{missing_cutoff}{Minimum fraction relative to surrounding data points
used in the check for missing channels}
}
\value{
MSThermResult object
}
\description{
Model a single protein from an MSThermExperiment object.
}
\details{
Valid quantification methods include:
    \describe{
       \item{"sum"}{use the sum of the spectrum values for each channel}
       \item{"median"}{use the median of the spectrum values for each
         channel}
       \item{"ratio.median"}{Like "median", but values for each spectrum
         are first converted to ratios according to "method.denom"
         channel}
       \item{"ratio.mean"}{Like "ratio.median" but using mean of ratios}
    }
Valid denominator methods include:
    \describe{
       \item{"first"}{Use the first value (lowest temperature point)
         (default)}
       \item{"max"}{Use the maximum value}
       \item{"top3"}{Use the mean of the three highest values}
       \item{"near"}{Use the median of all values greater than 80% of
         the first value}
    }
}
\examples{
control <- system.file("extdata", "demo_project/control.tsv", package="mstherm")
annots  <- system.file("extdata", "demo_project/annots.tsv",  package="mstherm")
expt    <- MSThermExperiment(control, annotations=annots)
expt    <- normalize_to_std(expt, "cRAP_ALBU_BOVIN", plot=FALSE)

model   <- model_protein(expt, "P38707", smooth=TRUE, bootstrap=FALSE)
summary(model)

}
