% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{clean_spectrum}
\alias{clean_spectrum}
\title{Clean a spectrum}
\usage{
clean_spectrum(
  peaks,
  min_mz,
  max_mz,
  noise_threshold,
  min_ms2_difference_in_da,
  min_ms2_difference_in_ppm,
  max_peak_num,
  normalize_intensity
)
}
\arguments{
\item{peaks}{A matrix of spectral peaks, with two columns: mz and intensity}

\item{min_mz}{The minimum mz value to keep, set to -1 to disable}

\item{max_mz}{The maximum mz value to keep, set to -1 to disable}

\item{noise_threshold}{The noise threshold, set to -1 to disable, all peaks have intensity < noise_threshold * max_intensity will be removed}

\item{min_ms2_difference_in_da}{The minimum mz difference in Da to merge peaks, set to -1 to disable, any two peaks with mz difference < min_ms2_difference_in_da will be merged}

\item{min_ms2_difference_in_ppm}{The minimum mz difference in ppm to merge peaks, set to -1 to disable, any two peaks with mz difference < min_ms2_difference_in_ppm will be merged}

\item{max_peak_num}{The maximum number of peaks to keep, set to -1 to disable}

\item{normalize_intensity}{Whether to normalize the intensity to sum to 1}
}
\value{
A matrix of spectral peaks, with two columns: mz and intensity
}
\description{
Clean a spectrum

This function will clean the peaks by the following steps:
1. Remove empty peaks (mz <= 0 or intensity <= 0).
2. Remove peaks with mz >= max_mz or mz < min_mz.
3. Centroid the spectrum by merging peaks within min_ms2_difference_in_da or min_ms2_difference_in_ppm.
4. Remove peaks with intensity < noise_threshold * max_intensity.
5. Keep only the top max_peak_num peaks.
6. Normalize the intensity to sum to 1.

Note: The only one of min_ms2_difference_in_da and min_ms2_difference_in_ppm should be positive.
}
\examples{
mz <- c(100.212, 169.071, 169.078, 300.321)
intensity <- c(0.3716, 7.917962, 100., 66.83)
peaks <- matrix(c(mz, intensity), ncol = 2, byrow = FALSE)
clean_spectrum(peaks, min_mz = 0, max_mz = 1000, noise_threshold = 0.01,
               min_ms2_difference_in_da = 0.02, min_ms2_difference_in_ppm = -1,
               max_peak_num = 100, normalize_intensity = TRUE)

}
