% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotraster.R
\name{plotraster}
\alias{plotraster}
\title{Plots a group-level utilization distribution}
\usage{
plotraster(
  x = file.path("Scaled", "All_Rasters_Scaled_Weighted_UDScaled.asc"),
  crsloc = NULL,
  xlatlon = NULL,
  locationpoints = NULL,
  calcCOA = FALSE,
  pointsincontourssave = NULL,
  trim = TRUE,
  myLocation = NULL,
  googlemap = FALSE,
  gmapsAPI = NULL,
  expandfactor = 1.6,
  mapzoom = NULL,
  mapsource = "google",
  maptype = "satellite",
  contour1colour = "red",
  contour2colour = "orange",
  positionscolour = "white",
  positionsalpha = 0.33,
  positionssize = 0.1,
  COAcolour = "black",
  COAalpha = 1,
  COAshape = 4,
  COAsize = 1,
  plottitle = "Aggregated 95\% and 50\% UD contours",
  plotsubtitle = "Scaled contours",
  legendtitle = "Percent UD Contours",
  plotcaption = paste0("movegroup, ", lubridate::today()),
  axisxlabel = "Longitude",
  axisylabel = "Latitude",
  legendposition = c(0.105, 0.8),
  fontsize = 12,
  fontfamily = "Times New Roman",
  filesavename = paste0(lubridate::today(), "_dBBMM-contours.png"),
  savedir = tempdir(),
  receiverlats = NULL,
  receiverlons = NULL,
  receivernames = NULL,
  receiverrange = NULL,
  recpointscol = "black",
  recpointsfill = "white",
  recpointsalpha = 0.5,
  recpointssize = 1,
  recpointsshape = 21,
  recbufcol = "grey75",
  recbuffill = "grey",
  recbufalpha = 0.5,
  reclabcol = "black",
  reclabfill = NA,
  reclabnudgex = 0,
  reclabnudgey = -200,
  reclabpad = 0,
  reclabrad = 0.15,
  reclabbord = 0,
  surface = TRUE,
  cropsavedimage = FALSE
)
}
\arguments{
\item{x}{Path to scaled raster generated by movegroup (/scaleraster/alignraster). Likely
file.path(movegroupsavedir, "Scaled", "All_Rasters_Scaled_Weighted_UDScaled.asc").}

\item{crsloc}{Location of saved CRS Rds file from movegroup.R. Likely the same as path. Likely
movegroup's savedir.}

\item{xlatlon}{If you want to also return a csv of your original locations labelled with which UD
contours they fall within, include the location of the LatLon raster here. Try
file.path(crsloc, "Scaled", "All_Rasters_Scaled_Weighted_LatLon.asc") . Default NULL will not produce
the csv output.}

\item{locationpoints}{If you want to also return a csv of your original locations labelled with which UD
contours they fall within, include the original input location points of animals, for xlatlon.
This should be a data frame which MUST have columns labelled "lat" and "lon".}

\item{calcCOA}{Calculate the centre of activity i.e. mean lat & lon point. Requires
locationpoints. Default FALSE.}

\item{pointsincontourssave}{Location and name to save the 'location in contours' csv related to
xlatlon and locationpoints, including the ".csv".}

\item{trim}{Remove NA & 0 UD values and crop the plot to remaining date extents? Shrinks lots of
dead space at the edges of the raster. Default TRUE.}

\item{myLocation}{Location for extents, format c(xmin, ymin, xmax, ymax). Default NULL, extents
auto-created from data. Set this if you want to expand or crop your map to cover a specific area.}

\item{googlemap}{If pulling basemap from Google maps, this sets expansion factors since Google
Maps tiling zoom setup doesn't align to myLocation extents. Default FALSE.}

\item{gmapsAPI}{Enter your google maps API here, quoted character string. Can leave NULL if
already registered with ggmap::register_google(). See Details for instructions. If you don't have
an API or don't want to get one, leave NULL, ensure mapsource is stamen, and maptype is
stamen-compatible.}

\item{expandfactor}{Extents expansion factor for basemap. 1.3 to 1.5 are the same zoom as 1. 1.6
is a big leap up in zoom out. 1.9 & maybe 1.7 or 1.8 is another step out. Ignored if not using
Google Maps.}

\item{mapzoom}{Highest number = zoomed in. Google: 3 (continent) - 21 (building). stamen: 0-18.
Default NULL is calculated based on your data.}

\item{mapsource}{Source for ggmap::get_map; google needs Google Maps API present. Options
“google”, “osm”, “stadia”.}

\item{maptype}{Type of map for ggmap::get_map param maptype. Options: Google mapsource: "terrain",
"terrain-background", "satellite", "roadmap", "hybrid". Stadia mapsource: "stamen_terrain",
"stamen_toner", "stamen_toner_lite", "stamen_watercolor", "stamen_terrain_background",
"stamen_toner_background", "stamen_terrain_lines", "stamen_terrain_labels", "stamen_toner_lines",
"stamen_toner_labels".}

\item{contour1colour}{Colour for contour 1, typically 95pct, default "red".}

\item{contour2colour}{Colour for contour 2, typically 50pct, default "orange".}

\item{positionscolour}{Colour for original animal locations, if xlatlon not NULL. Default "white".}

\item{positionsalpha}{Alpha value for positions, default 0.33, values from 0 (fully transparent)
to 1 (fully parent).}

\item{positionssize}{Point size for positions, default 0.1.}

\item{COAcolour}{Colour for Centre of Activity marker, if plotted. Default "black".}

\item{COAalpha}{Alpha value for Centre of Activity point, default 1, values from 0 (fully transparent)
to 1 (fully parent).}

\item{COAshape}{Shape of Centre of Activity marker, default 4, an X. Permissible values 0 to 25.}

\item{COAsize}{Size of COA point, default 1.}

\item{plottitle}{Title of the resultant plot, default "Aggregated 95pct and 50pct UD contours".}

\item{plotsubtitle}{Plot subtitle, default "Scaled contours". Can add the n of your individuals.}

\item{legendtitle}{Legend title, default "Percent UD Contours".}

\item{plotcaption}{Plot caption, default "movegroup" + today's date.}

\item{axisxlabel}{Default "Longitude".}

\item{axisylabel}{Default "Latitude".}

\item{legendposition}{Vector of 2, format c(1,2), Proportional distance of (middle?) of legend
box from L to R, percent distance from Bottom to Top. Values 0 to 1. Default c(0.11, 0.85).}

\item{fontsize}{Font size, default 12.}

\item{fontfamily}{= Font family, default "Times New Roman".}

\item{filesavename}{File savename, default today's date + "_dBBMM-contours.png".}

\item{savedir}{Save outputs to a temporary directory (default) else change to current directory
e.g. "/home/me/folder". Do not use getwd() here. No terminal slash. E.g.
file.path(movegroupsavedir, "Plot") . Auto-created if it doesn't exist.}

\item{receiverlats}{Vector of latitudes for receivers to be plotted.}

\item{receiverlons}{Vector of longitudes for receivers to be plotted. Same length as receiverlats.}

\item{receivernames}{Vector of names for receivers to be plotted. Same length as receiverlats.}

\item{receiverrange}{Single (will be recycled), or vector (same length as receiverlats) of
detection ranges in metres for receivers to be plotted. If you have a max and a (e.g.) 90 percent
detection range, probably use max.}

\item{recpointscol}{Colour of receiver centrepoint outlines. Default "black".}

\item{recpointsfill}{Colour of receiver centrepoint fills. Default "white".}

\item{recpointsalpha}{Alpha value of receiver centrepoint fills, 0 (invisible) to 1 (fully
visible). Default 0.5.}

\item{recpointssize}{Size of receiver points. Default 1.}

\item{recpointsshape}{Shape of receiver points, default 21, circle with outline and fill.}

\item{recbufcol}{Colour of the receiver buffer circle outlines. Default "grey75"}

\item{recbuffill}{Colour of the receiver buffer circle fills. Default "grey".}

\item{recbufalpha}{Alpha value of receiver buffer fills, 0 (invisible) to 1 (fully visible).
Default 0.5.}

\item{reclabcol}{Receiver label text colour. Default "black".}

\item{reclabfill}{Receiver label fill colour, NA for no fill. Default NA.}

\item{reclabnudgex}{Receiver label offset nudge in X dimension. Default 0.}

\item{reclabnudgey}{Receiver label offset nudge in Y dimension. Default -200.}

\item{reclabpad}{Receiver label padding in lines. Default 0.}

\item{reclabrad}{Receiver label radius in lines. Default 0.15.}

\item{reclabbord}{Receiver label border in mm. Default 0.}

\item{surface}{Plot complete UD surface along with contours. Default TRUE.}

\item{cropsavedimage}{Crop the output image with knitr::plot_crop which uses pdfcrop on PDFs,
otherwise magick::image_trim. magick requires system pre-install. deb: libmagick++-dev (Debian,
Ubuntu), rpm: ImageMagick-c++-devel (Fedora, CentOS, RHEL), csw: imagemagick_dev (Solaris), brew:
imagemagick@6 (MacOS). Default FALSE.}
}
\value{
Individual-level utilization distributions, saved as rasters, as well as calculated
volume area estimates for 50 and 95pct contours, saved in a .csv file.
}
\description{
Plots 50 and 95pct contours of a group-level utilization distribution raster on a spatial map
background. Contains functionality to also visualize geographic locations of individual listening
stations (e.g., acoustic receivers) as well as the entire surface UD.
}
\details{
For plottitle, you can use the term 'home range' when an animal can be detected wherever it goes
i.e. using GPS, satellite or acoustic telemetry whereby it is known that acoustic receivers cover
the entire home range of the study species. This term is problematic when applied to a passive
acoustic telemetry setting where an array of non-overlapping receivers are used to assess local
space use patterns i.e. the home range is bigger than the coverage by the acoustic array.

Errors and their origins:
\enumerate{
\item Error in gzfile(file, "rb") : cannot open the connection. In addition: Warning message: In
gzfile(file, "rb"): cannot open compressed file '/var/folders/dl/etc/ggmap/index.rds',
probable reason 'No such file or directory'. Cause: index.rds may not have been created, due to a
problem with ggmap::get_map, likely due to your API key failing silently.
Filename too long - solve with filename = "whatever" but doesn't do anything. Added issue in
github: https://github.com/dkahle/ggmap/issues/346 .
API key help: https://github.com/dkahle/ggmap/issues/235 .
\item trying to read file: All_Rasters_Scaled_Weighted_UDScaled.asc: Error in CPL_read_gdal(
as.character(x), as.character(options), as.character(driver),: file not found. Check x is correct.
\item Error in grid.Call.graphics...: Empty raster: mapzoom likely set too low, returning no tiles.
Increase mapzoom number.
\item Not Found (HTTP 404). Failed to acquire tile /...png: Tiles are unavailable for ocean, and may
be unavailable at the chosen zoom level for the specific region of interest. Inspect the output
map and try a lower level (number) of mapzoom.
}
\subsection{How to get Google map basemaps}{

(from https://www.youtube.com/watch?v=O5cUoVpVUjU):
\enumerate{
\item Sign up with dev console: a. You must enter credit card details, but won’t be charged if your
daily API requests stay under the limit. b. Follow the link:
https://console.cloud.google.com/projectselector2/apis/dashboard?supportedpurview=project c.
Sign up for Google cloud account (it may auto populate your current gmail), click agree and
continue. d. Click the navigation email in the top left corner and click on Billing. e. Create a
billing account – they will NOT auto charge after trial ends. f. Enter information, click on
'start my free trial'. They may offer a free credit for trying out their service. More pricing
details: https://mapsplatform.google.com/pricing/ . g. Click “Select a Project” then
“New project” in the top right corner. h. Enter Project Name, leave Location as is, click
“Create”. i. You should now see your project name at the top, where the drop-down menu is.
\item Enable Maps and Places API: a. Click 'Library' on the left. b. In the search field type “Maps”
. c. Scroll down, click “Maps Java Script API”. d. Click Enable. e. Click 'Library' again, search
“Places”, click on “Places API”. f. Click Enable.
\item Create Credentials for API  Key: a. Return to 'APIs & Services' page. b. Click on Credentials.
c. At the top click 'Create Credentials > API Key'. d. API key should pop up with option to copy
it. e. You can restrict the key if you want by following steps 4 & 5 here:
https://www.youtube.com/watch?v=O5cUoVpVUjU&t=232s
}
}
}
\examples{
\donttest{
# Having run the movegroup and scaleraster function examples:
plotraster(
  x = file.path(tempdir(), "Scaled", "All_Rasters_Scaled_Weighted_UDScaled.asc"),
  mapzoom = 14,
  mapsource = "stamen",
  maptype = "terrain",
  savedir = file.path(tempdir(), "Plot"),
  xlatlon = file.path(tempdir(), "Scaled", "All_Rasters_Scaled_Weighted_LatLon.asc"),
  locationpoints = TracksCleaned |> dplyr::rename(lat = "Lat", lon = "Lon"),
  pointsincontourssave = file.path(tempdir(), "Scaled", "pointsincontours.csv"))
}
}
\author{
Simon Dedman, \email{simondedman@gmail.com}

Maurits van Zinnicq Bergmann, \email{mauritsvzb@gmail.com}
}
