% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/starting_angle.R
\name{starting_angle}
\alias{starting_angle}
\title{Starting angle}
\usage{
starting_angle(x0, x1, y0, y1, swap_x_y = TRUE)
}
\arguments{
\item{x0}{x-value of the first point.}

\item{x1}{x-value of the second point.}

\item{y0}{y-value of the first point.}

\item{y1}{y-value of the second point.}

\item{swap_x_y}{Whether to compute the angle relative to the x or y axis.
Defaults to \code{TRUE}, indicating that the angle is relative to the y axis.}
}
\value{
Angle in degrees with \eqn{-180 <= angle <= 180}.
}
\description{
Computes the angle (in degrees) between a line,
defined by two points with coordinates (\code{x0}, \code{y0})
and (\code{x1}, \code{y1}), and the specified axis.
}
\details{
If the angle is computed relative to the x axis, counterclockwise
changes are counted as positive. If the angle is computed relative to the
y axis, clockwise changes are counted as positive.
}
\examples{
# Note that not the mathematical definition of angle is used by default:
starting_angle(0, 1, 0, 0)
starting_angle(0, 1, 0, 0, swap_x_y = FALSE)
# angles are clockwise and relative to the y-axis.

# Note that return values are in the range [-180, 180], not [0, 360]:
starting_angle(0, -1, 0, -1)
starting_angle(0, 1, 0, -1, swap_x_y = FALSE)

}
\references{
Wirth, R., Foerster, A., Kunde, W., & Pfister, R. (2020).
Design choices: Empirical recommendations for designing two-dimensional
finger tracking experiments. Behavior Research Methods, 52, 2394 - 2416.
\doi{10.3758/s13428-020-01409-0}
}
