% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{describe_share}
\alias{describe_share}
\title{Describe a MotherDuck share}
\usage{
describe_share(.con, share_name)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}

\item{share_name}{Character. The name of the shared path to describe.}
}
\value{
A tibble containing metadata about the share, including object names, types,
and privileges associated with the share.
}
\description{
Retrieves detailed metadata about a specific share in MotherDuck, including
the objects it contains, their types, and privileges granted.
}
\details{
This function executes the \code{md_describe_database_share} system function
to obtain comprehensive information about the specified share.
The result is returned as a tibble for easy inspection and manipulation in R.
}
\examples{
\dontrun{
con <- DBI::dbConnect(duckdb::duckdb(dbdir = tempfile()))
share_info <- describe_share(con, "analytics.sales_share")
print(share_info)
}

}
\seealso{
Other db-manage: 
\code{\link{alter_table_schema}()},
\code{\link{copy_tables_to_new_location}()},
\code{\link{create_database}()},
\code{\link{create_if_not_exists_share}()},
\code{\link{create_or_replace_share}()},
\code{\link{create_schema}()},
\code{\link{create_table}()},
\code{\link{delete_and_create_schema}()},
\code{\link{delete_database}()},
\code{\link{delete_schema}()},
\code{\link{delete_table}()},
\code{\link{drop_share}()},
\code{\link{list_owned_shares}()},
\code{\link{list_shared_with_me_shares}()},
\code{\link{upload_database_to_md}()}
}
\concept{db-manage}
