% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomapMoment.R
\name{morphomapMoment}
\alias{morphomapMoment}
\title{morphomapMoment}
\usage{
morphomapMoment(cp, mp, delta = 0.1)
}
\arguments{
\item{cp}{matrix: coordinates of the external outline}

\item{mp}{matrix: coordinates of the internal outline}

\item{delta}{numeric: picture elements of adjustable side length}
}
\value{
Ix numeric: moment of inertia around the x axis

Iy numeric: moment of inertia around the y axis

Ixy numeric: product of inertia around the x and y axis
}
\description{
Calculate the moment of inertia around the x and y axes and the product of inertia
}
\examples{
#create a section
extsec<-morphomapCircle(10,1000)
intsec<-morphomapCircle(8,1000)
InMs<-morphomapMoment(extsec,intsec,delta=0.1)
}
\author{
Antonio Profico, Luca Bondioli, Pasquale Raia, Paul O'Higgins, Damiano Marchi
}
