% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_fordistribution.R
\name{d_nextgenclusterdistn}
\alias{d_nextgenclusterdistn}
\alias{p_nextgenclusterdistn}
\alias{q_nextgenclusterdistn}
\alias{r_nextgenclusterdistn}
\title{The next-generation cluster size distribution}
\usage{
d_nextgenclusterdistn(
  x = 5,
  seed.size = 1,
  epi.para = list(mean = 1, disp = 0.5, shift = 0.2),
  offspring.type = "D",
  is.log = FALSE
)

p_nextgenclusterdistn(
  q = 10.5,
  seed.size = 1,
  epi.para = list(mean = 1, disp = 0.5, shift = 0.2),
  offspring.type = "D",
  lower.tail = TRUE,
  is.log = FALSE
)

q_nextgenclusterdistn(
  p = 0.8,
  seed.size = 1,
  epi.para = list(mean = 1, disp = 0.5, shift = 0.2),
  offspring.type = "D",
  lower.tail = TRUE
)

r_nextgenclusterdistn(
  n = 10,
  seed.size = 1,
  epi.para = list(mean = 1, disp = 0.5, shift = 0.2),
  offspring.type = "D"
)
}
\arguments{
\item{x}{A scalar, or a vector of positive integer, for the next-generation cluster size.  The value of \code{x} must be not less than \code{seed.size}.}

\item{seed.size}{A scalar, or a vector of positive integer.
For vector type of \code{seed.size}, it only applies to \code{d_nextgenclusterdistn()}, \code{p_nextgenclusterdistn()}, and \code{q_nextgenclusterdistn()}.
If \code{seed.size} and \code{x}, \code{q} or \code{p} are vectors, \code{seed.size} should be of the same length as \code{x}, \code{q} or \code{p}.}

\item{epi.para}{A list (\code{list}) of pre-defined epidemiological parameters for offspring distribution, in the format of \code{list(mean = ?, disp = ?, shift = ?)},
where the three parameters accept non-negative values.
Each parameter can be either a scalar, or a vector.
For the parameters being assigned with values of vectors, the vectors should be of the same length.
For Delaporte distribution, the value of \code{mean} should be larger than the value of \code{shift}.}

\item{offspring.type}{A character label (\code{character}) indicating the type of distribution used to describe the offspring distribution.
It only accepts one of the following values:
\itemize{
\item{\code{"D"}}{ indicates the \emph{Delaporte} distribution, }
\item{\code{"NB"}}{ indicates the \emph{negative binomial} distribution, }
\item{\code{"G"}}{ indicates the \emph{geometric} distribution, or }
\item{\code{"P"}}{ indicates the \emph{Poisson} distribution. }
}
By default, \code{offspring.type = 'D'}.}

\item{is.log}{A logical variable, under which probability would be taken natural logarithm, if \code{is.log = TRUE}.
By default, \code{is.log = FALSE}.}

\item{q}{A scalar, or a vector of positive number (not necessarily integer), for the next-generation cluster size. The value of \code{q} must be not less than \code{seed.size}.}

\item{lower.tail}{A logical variable, under which the probability is cumulative distribution function (CDF, i.e., \emph{P(X <= x)}), if \code{lower.tail = TRUE}, and otherwise, 1 - CDF (i.e., \emph{P(X > x)}).
By default, \code{lower.tail = TRUE}.}

\item{p}{A scalar, or a vector of probability (i.e., ranging from 0 to 1).}

\item{n}{A scalar of positive integer.}
}
\value{
For the values returned from the four functions,
\itemize{
\item{\code{d_nextgenclusterdistn()}}{ is the \emph{probability mass function} (PMF), and it returns value of probability (i.e., ranging from 0 to 1); }
\item{\code{p_nextgenclusterdistn()}}{ is the \emph{cumulative distribution function} (CDF), and it returns value of probability (i.e., ranging from 0 to 1); }
\item{\code{q_nextgenclusterdistn()}}{ is the \emph{quantile function}, and it returns value of quantile (positive integer); and }
\item{\code{r_nextgenclusterdistn()}}{ is the \emph{random variable generating function}, and it generates a set of \code{n} random variables (positive integers). }
}
}
\description{
Density, cumulative distribution, quantile, and random variable generating functions for the \strong{next-generation cluster size} distribution with pre-defined epidemiological parameters.
}
\details{
Function \code{d_nextgenclusterdistn()} returns the probability of having a next-generation case cluster with size \code{x} generated by \code{seed.size} index cases, where (\code{seed.size}) is given.

Function \code{p_nextgenclusterdistn()} returns the probability of having a next-generation case cluster with size less than or equal to, or larger than \code{q} (depending on the value of \code{lower.tail}), generated by \code{seed.size} index cases, where (\code{seed.size}) is given.

Function \code{q_nextgenclusterdistn()} returns a value such that there is a probability of \code{p} for having a next-generation case cluster with size less than or equal to, or larger than this value (depending on the value of \code{lower.tail}) generated by \code{seed.size} index cases, where (\code{seed.size}) is given.

Function \code{r_nextgenclusterdistn()} returns a set of random variables of \code{n} next-generation cluster size, given (\code{seed.size}).
}
\note{
Depending on the values of parameters, the functions could take hours to complete, given the double-summation nature for the Delaporte distribution.
}
\examples{
## Please see the "Usage" section.

}
\references{
Blumberg S, Lloyd-Smith JO. Inference of R 0 and transmission heterogeneity from the size distribution of stuttering chains. \emph{PLoS Computational Biology}. 2013 May 2;9(5):e1002993.
\doi{10.1371/journal.pcbi.1002993}

Zhao S, Chong MK, Ryu S, Guo Z, He M, Chen B, Musa SS, Wang J, Wu Y, He D, Wang MH. Characterizing superspreading potential of infectious disease: Decomposition of individual transmissibility. \emph{PLoS Computational Biology}. 2022;18(6):e1010281.
\doi{10.1371/journal.pcbi.1010281}
}
\seealso{
\code{\link[Delaporte:ddelap]{Delaporte}} for the parameterization of Delaporte distribution.
}
