% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{h_assert_nested_models}
\alias{h_assert_nested_models}
\title{Ensure Two Models Are Nested}
\usage{
h_assert_nested_models(model_basic, model_augmented, any_reml)
}
\arguments{
\item{model_basic, model_augmented}{(\code{mmrm})\cr model fits.}

\item{any_reml}{(\code{flag})\cr \code{TRUE} or \code{FALSE} indicating whether or not
either model used REML estimation.}
}
\value{
\code{TRUE} if \code{model_basic} is nested within \code{model_augmented}.
Otherwise, an error is thrown.
}
\description{
Throws an error if \code{model_basic} isn't nested within \code{model_augmented}.
}
\details{
The following checks are applied in this order, and an error is thrown if any
of the conditions are not met:
\enumerate{
\item The fits must have the same visit, subject, and grouping variables.
\item The covariates of \code{model_basic} must be the same as or a subset of the
covariates of \code{model_augmented}.
\item The covariance structure of \code{model_basic} must be the same as or a special
case of the covariance structure of \code{model_augmented}.
}

Finally, if all these checks were passed, a warning is thrown if the two fits
have identical covariates and covariance structures.
}
\keyword{internal}
