% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultipleTables-method-exported.R
\name{MultipleTables.plot}
\alias{MultipleTables.plot}
\title{Plot Method for \code{Multipletables} objects}
\usage{
MultipleTables.plot(
  multiple_tables_object,
  plot_type = "forest",
  layout_type = "overlay",
  selected_study_names = NULL,
  xlim = NULL,
  add_vertical = NULL,
  show_CI = TRUE,
  by = "line_type"
)
}
\arguments{
\item{multiple_tables_object}{The object inheriting from class \code{Multipletables}.}

\item{plot_type}{a character string specifying the kind of plots to
produce. Options are \code{density} and \code{forest} (default). See details}

\item{layout_type}{a character string specifying the type of the density plots (i.e., when \code{plot_type=‘density’}).
Options are \code{sidebyside} and \code{overlay} (default). This argument is NULL when \code{plot_type=‘forest’}}

\item{selected_study_names}{a numeric value or vector specifying which studies to
be plotted. By default (when \code{NULL}), all of the studies will be plotted.}

\item{xlim}{a numeric value specifying the lower and upper limits of the x-axis. Default is NULL.
For forest plots, if the lower bound of any measure is smaller than \code{xlim[1]} or the upper bound of
any measure is larger than \code{xlim[2]}, arrows will be used at
the limits to denote the bounds exceed the specified ranges.}

\item{add_vertical}{a numeric value specifying the x-value for a vertical
reference line at \code{x=addline}. Default is NULL.}

\item{show_CI}{a logical value; If TRUE (default) the forest plot will show the lower & upper bounds of CIs,
else the the lower & upper bounds of CIs will be omitted. This argument is always NULL when \code{plot_type=‘density’}.}

\item{by}{a character string specifying the way to distinguish different plots. Options are \code{line_type} (default) and \code{color}.}
}
\value{
A ggplot2 object is returned.
}
\description{
Produces a variety of plots for multiple tables analysis
}
\details{
If \code{plot_type=‘density’} and \code{layout_type='sidebyside'}, the posterior distributions of all
study-specific measure are displayed side by side in 4-panel plots with study names.

If \code{plot_type=‘density’} and \code{layout_type='overlap'}, the posterior distributions of all
study-specific measure are displayed in one graph. To clarity, it
is advisable to specify a few studies by \code{selected_study_names} argument.

If \code{type='forest')} and \code{layout_type='NULL'}, a forest plot of all study-specific and
overall measure with 95\% credible/confidence intervals are plotted.
}
\examples{
\donttest{
 library(mmeta)
 library(ggplot2)
 ## Analyze the dataset colorectal to conduct exact inference of the odds ratios
 data(colorectal)
 colorectal['study_name'] <- colorectal['studynames']
 ## If exact method is used, the codes for sampling method are similar.
 ## Create object multiple_tables_obj_exact
 multiple_tables_obj_exact <- MultipleTables.create(data=colorectal,
  measure='OR', model= 'Sarmanov')
 ## Model fit default
 multiple_tables_obj_exact <- MultipleTables.modelFit(multiple_tables_obj_exact, method = 'exact')
 ## Summary of the fitting process (default)
 multiple_tables_obj_exact <- MultipleTables.summary(multiple_tables_obj_exact)
 ## Density plot, overlay
 ## Note: There are no enough types of line, if we have too many densities!
 MultipleTables.plot(multiple_tables_obj_exact, plot_type = 'density',
 layout_type = 'overlay')
 ## Choose Set by = ‘color’
 MultipleTables.plot(multiple_tables_obj_exact, plot_type = 'density',
 layout_type = 'overlay',by = 'color')
 ## Set by = ‘color’ and specify xlim as 0 to 5.
 MultipleTables.plot(multiple_tables_obj_exact, plot_type = 'density',
 layout_type = 'overlay', by = 'color', xlim = c(0,5))
 ## Set by = ‘color’ and specify xlim as 0 to 5 and add vertical line at OR = 1
 MultipleTables.plot(multiple_tables_obj_exact, plot_type = 'density',
 layout_type = 'overlay', by = 'color',xlim = c(0,5), add_vertical = 1)
 ## If select three studies
 MultipleTables.plot(multiple_tables_obj_exact, plot_type = 'density',
 layout_type = 'overlay',selected_study_names = c('Bell','Chen','Oda'), xlim = c(0,5))
 ## We can add external layouts for the return ggplot2. xlab as Odds ratio
 ggplot2_obj <- MultipleTables.plot(multiple_tables_obj_exact,
 plot_type = 'density', layout_type = 'overlay', by = 'color',xlim = c(0,5))
 ggplot2_obj + xlab('Odds Ratio')  + ggtitle('OR ration for XX cancer')
 ## density plot, plot side by side
 MultipleTables.plot(multiple_tables_obj_exact, plot_type = 'density',
 layout_type = 'side_by_side')
 ## Forest plot (default)
 MultipleTables.plot(multiple_tables_obj_exact, plot_type = 'forest')
 ## forest plot: not show the CIs
 MultipleTables.plot(multiple_tables_obj_exact, plot_type = 'forest',
 add_vertical =  1, show_CI = FALSE)
}
}
\seealso{
\code{MultipleTables.create}, \code{MultipleTables.modelFit}, and \code{MultipleTables.summary}.
}
