% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mize.R
\name{mize_step_summary}
\alias{mize_step_summary}
\title{Mize Step Summary}
\usage{
mize_step_summary(opt, par, fg, par_old = NULL, calc_fn = NULL)
}
\arguments{
\item{opt}{Optimizer to generate summary for, from return value of
\code{\link{mize_step}}.}

\item{par}{Vector of parameters at the end of the iteration, from return value
of \code{\link{mize_step}}.}

\item{fg}{Function and gradient list. See the documentation of
\code{\link{mize}}.}

\item{par_old}{(Optional). Vector of parameters at the end of the previous
iteration. Used to calculate step size.}

\item{calc_fn}{(Optional). If \code{TRUE}, force calculation of function if
not already cached in \code{opt}, even if it would not be needed for
convergence checking.}
}
\value{
A list with the following items: \itemize{

 \item \code{opt} Optimizer with updated state (e.g. function and gradient
 counts).

 \item \code{iter} Iteration number.

 \item \code{f} Function value at \code{par}.

 \item \code{g2n} 2-norm of the gradient at \code{par}.

 \item \code{ginfn} Infinity-norm of the gradient at \code{par}.

 \item \code{nf} Number of function evaluations so far.

 \item \code{ng} Number of gradient evaluations so far.

 \item \code{step} Size of the step between \code{par_old} and \code{par},
 if \code{par_old} is provided.

 \item \code{alpha} Step length of the gradient descent part of the step.

 \item \code{mu} Momentum coefficient for this iteration}
}
\description{
Produces a result summary for an optimization iteration. Information such as
function value, gradient norm and step size may be returned.
}
\details{
By default, convergence tolerance parameters will be used to determine what
function and gradient data is returned. The function value will be returned if
it was already calculated and cached in the optimization iteration. Otherwise,
it will be calculated only if a non-null absolute or relative tolerance value
was asked for. A gradient norm will be returned only if a non-null gradient
tolerance was specified, even if the gradient is available.

Note that if a function tolerance was specified, but was not calculated for
the relevant value of \code{par}, they will be calculated here and the
calculation does contribute to the total function count (and will be cached
for potential use in the next iteration). The same applies for gradient
tolerances and gradient calculation. Function and gradient calculation can
also be forced here by setting the \code{calc_fn} and \code{calc_gr}
(respectively) parameters to \code{TRUE}.
}
\examples{
rb_fg <- list(
  fn = function(x) {
    100 * (x[2] - x[1] * x[1])^2 + (1 - x[1])^2
  },
  gr = function(x) {
    c(
      -400 * x[1] * (x[2] - x[1] * x[1]) - 2 * (1 - x[1]),
      200 * (x[2] - x[1] * x[1])
    )
  }
)
rb0 <- c(-1.2, 1)

opt <- make_mize(method = "BFGS", par = rb0, fg = rb_fg, max_iter = 30)
mize_res <- mize_step(opt = opt, par = rb0, fg = rb_fg)
# Get info about first step, use rb0 to compare new par with initial value
step_info <- mize_step_summary(mize_res$opt, mize_res$par, rb_fg, rb0)
}
