% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qp_solver.R
\name{qp_solver_nloptr}
\alias{qp_solver_nloptr}
\title{Solve Quadratic Programming Problem using nloptr}
\usage{
qp_solver_nloptr(
  n,
  A,
  b,
  c,
  x_max = 1,
  print_message = FALSE,
  xtol_rel = 1e-08,
  maxeval = 10000,
  print_level = 0,
  ...
)
}
\arguments{
\item{n}{An integer representing the number of decision variables.}

\item{A}{A matrix representing the quadratic coefficients.}

\item{b}{A numeric vector representing the linear coefficients.}

\item{c}{A numeric scalar representing the constant term in the objective function.}

\item{x_max}{An integer representing the upper bound for the decision variables. Default is 1.}

\item{print_message}{A logical value indicating whether to print optimization details. Default is FALSE.}

\item{xtol_rel}{A numeric value specifying the relative tolerance for convergence. Default is \code{1e-8}.}

\item{maxeval}{An integer specifying the maximum number of function evaluations. Default is 10000.}

\item{print_level}{An integer controlling the verbosity of output. Default is 0.}

\item{...}{Additional control parameters for \code{nloptr}.}
}
\value{
A list containing:
\item{f_cd}{The optimal objective function value.}
\item{x_value}{The optimal values of the decision variables.}
}
\description{
This function solves a quadratic programming problem using the Sequential Least Squares Programming (SLSQP) algorithm from the \code{nloptr} package.
}
\seealso{
\code{\link{qp_solver}}, \code{\link{qp_solver_DEoptim}}, \code{\link{qp_solver_GA}}
}
