% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missForestPredict.R
\name{missForestPredict}
\alias{missForestPredict}
\title{Imputes a new dataframe based on the missForest models}
\usage{
missForestPredict(missForestObj, newdata, x_init = NULL)
}
\arguments{
\item{missForestObj}{missForest object as returned by the missForest function.}

\item{newdata}{new data to impute. The column names should be the same as in the imputation model.}

\item{x_init}{initialization dataframe in case custom initialization mode has been used.
It needs to be complete dataframe (with no missing values). See vignette for a full example.}
}
\value{
an imputed dataframe
}
\description{
Imputes a new dataframe based on the missForest models. The same number of iterations as in missForest are used.
}
\details{
A new observation is initialized in the same manner as passed through the \code{initialization}
parameter to the \code{missForest} function. Then, variables are imputed in the same sequence and for the same
number of iterations using the random models saved for each iteration. This ensures that a new observation is
imputed in the same manner as the training set (imputed by the function \code{missForest}).
Re-imputing the training set with the \code{missForestPredict} will yield the same result as
the original imputation returned by the \code{missForest} function.
}
\examples{
data(iris)
# split train / test and create missing values
id_test <- sample(1:nrow(iris), floor(nrow(iris)/3))

iris_train <- iris[-id_test,]
iris_test <- iris[id_test,]

iris_train_miss <- produce_NA(iris_train, proportion = 0.1)
iris_test_miss <- produce_NA(iris_test, proportion = 0.1)

# impute train and learn imputation models
iris_train_imp_obj <- missForest(iris_train_miss, save_models = TRUE, num.threads = 2)

# impute test
iris_test_imp_new <- missForestPredict(iris_train_imp_obj, newdata = iris_test_miss)
head(iris_test_imp_new)

}
