% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocks.R
\name{name.blocks}
\alias{name.blocks}
\title{Name imputation blocks}
\usage{
name.blocks(x, prefix = "B")
}
\arguments{
\item{x}{A \code{data.frame}, character vector with
variable names, or \code{list} with variable names.}

\item{prefix}{A character vector of length 1 with the prefix to
be using for naming any unnamed blocks with two or more variables.}
}
\value{
A named list of character vectors with variables names.
}
\description{
This helper function names any unnamed elements in the \code{blocks}
specification. This is a convenience function.
}
\details{
This function will name any unnamed list elements specified in
the optional argument \code{blocks}. Unnamed blocks
consisting of just one variable will be named after this variable.
Unnamed blocks containing more than one variables will be named
by the \code{prefix} argument, padded by an integer sequence
stating at 1.
}
\examples{
blocks <- list(c("hyp", "chl"), AGE = "age", c("bmi", "hyp"), "edu")
name.blocks(blocks)
}
\seealso{
\code{\link{mice}}
}
