% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mevr.R
\name{dmev}
\alias{dmev}
\alias{pmev}
\alias{qmev}
\alias{rmev}
\title{The Metastatistical Extreme Value Distribution}
\usage{
dmev(x, w, c, n)

pmev(q, w, c, n)

qmev(p, w, c, n)

rmev(N, w, c, n)
}
\arguments{
\item{x, q}{numeric vector or single values of quantiles for \code{dmev} 
and \code{pmev}.}

\item{w, c}{vector or single values of shape and scale parameter of the 
MEV distribution. If a vector, w and c must have the same length as n.}

\item{n}{Either mean number of wet events per year for the SMEV, 
or a vector for yearly MEVD calculations, i.e. one value per year (see details). 
If a vector, n must have the same length as w and c.}

\item{p}{vector or single value of probabilities for \code{qmev}.}

\item{N}{Number of observations to sample from the MEVD or SMEV.}
}
\value{
\code{dmev} gives the density function, \code{pmev} gives the distribution function, 
\code{qmev} gives the quantile function and \code{rmev} provides random realizations of 
the SMEV and MEVD.
}
\description{
Density, distribution function, quantile function and random generation for the 
MEV distribution with shape parameter 'w', scale parameter 'c'. 
Parameter 'n' refers either to the mean number of wet days per year in case 
of the simplified MEV, or to the number of wet days for each year.
}
\section{Functions}{
\itemize{
\item \code{pmev()}: distribution quantile function

\item \code{qmev()}: quantile function

\item \code{rmev()}: random generation function

}}
\examples{
# SMEV
dmev(1200:1300, 0.7, 20, 110)
pmev(1200:1300, 0.7, 70, 110)
qmev(1 - 1 / seq(5,50,5), 0.7, 70, 110)

# MEVD: 50-year event of 10 years Weibull series
w <- rnorm(10, 0.8, 0.1) # shape parameter
c <- rnorm(10, 200, 30) # scale parameter
n <- rnorm(10, 200, 50) # number of wet days
qmev(1 - 1 / 50, w, c, n)

# rl-plot
rp <- seq(5, 50, 5)
rl <- qmev(1 - 1 / rp, w, c, n)
pp <- (1:length(rp)) / (length(rp) + 1)
plot(pp, rl, type = "o")
}
