% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull_tail_test.R
\name{censored_weibull_fit}
\alias{censored_weibull_fit}
\title{Fit Weibull distribution to censored data}
\usage{
censored_weibull_fit(x, thresholds)
}
\arguments{
\item{x}{A tibble which is most commonly a result of function 
\code{\link{weibull_tail_test}}.}

\item{thresholds}{A numeric or vector of quantiles which shal be tested 
as optimal threshold for left-censoring.}
}
\value{
A tibble with the optimal threshold itself and 
the Weibull scale and shape parameters obtained from the censored sample.
}
\description{
Finds the optimal left-censoring threshold(s) at which 
the data series should be censored to make sure that the observations 
in the tail are likely sampled from a Weibull distribution
}
\examples{
data("dailyrainfall")
wbtest <- weibull_tail_test(dailyrainfall)
censored_weibull_fit(wbtest, 0.9)

}
