% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solutions_df.R
\name{calc_assoc_pval_matrix}
\alias{calc_assoc_pval_matrix}
\title{Calculate p-values for all pairwise associations of features in a data list}
\usage{
calc_assoc_pval_matrix(dl, verbose = FALSE, cat_test = "chi_squared")
}
\arguments{
\item{dl}{A nested list of input data from \code{data_list()}.}

\item{verbose}{If TRUE, output progress to the console.}

\item{cat_test}{String indicating which statistical test will be used to
associate cluster with a categorical feature. Options are "chi_squared" for
the Chi-squared test and "fisher_exact" for Fisher's exact test.}
}
\value{
A "matrix" class object containing pairwise association p-values
between the features in the provided data list.
}
\description{
Calculate p-values for all pairwise associations of features in a data list
}
\examples{
data_list <- data_list(
    list(income, "household_income", "demographics", "ordinal"),
    list(pubertal, "pubertal_status", "demographics", "continuous"),
    list(anxiety, "anxiety", "behaviour", "ordinal"),
    list(depress, "depressed", "behaviour", "ordinal"),
    uid = "unique_id"
)

assoc_pval_matrix <- calc_assoc_pval_matrix(data_list)
}
