% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tlf_ae_specific_subgroup.R
\name{tlf_ae_specific_subgroup}
\alias{tlf_ae_specific_subgroup}
\title{Specific adverse events table for subgroup analysis}
\usage{
tlf_ae_specific_subgroup(
  outdata,
  meddra_version,
  source,
  col_rel_width = NULL,
  text_font_size = 9,
  orientation = "landscape",
  footnotes = NULL,
  title = NULL,
  path_outdata = NULL,
  path_outtable = NULL
)
}
\arguments{
\item{outdata}{An \code{outdata} object created by \code{\link[=prepare_ae_specific]{prepare_ae_specific()}}.}

\item{meddra_version}{A character value of the MedDRA version
for this dataset.}

\item{source}{A character value of the data source.}

\item{col_rel_width}{Column relative width in a vector e.g. c(2,1,1) refers to 2:1:1.
Default is NULL for equal column width.}

\item{text_font_size}{Text font size.  To vary text font size by column, use
numeric vector with length of vector equal to number of columns
displayed e.g. c(9,20,40).}

\item{orientation}{Orientation in 'portrait' or 'landscape'.}

\item{footnotes}{A character vector of table footnotes.}

\item{title}{Term "analysis", "observation"and "population") for collecting
title from metadata or a character vector of table titles.}

\item{path_outdata}{A character string of the outdata path.}

\item{path_outtable}{A character string of the outtable path.}
}
\value{
RTF file and the source dataset for AE specific subgroup analysis table.
}
\description{
Specific adverse events table for subgroup analysis
}
\examples{
meta <- meta_ae_example()
prepare_ae_specific_subgroup(meta,
  population = "apat",
  observation = "wk12",
  parameter = "rel",
  subgroup_var = "SEX",
  display_subgroup_total = TRUE
) |>
  format_ae_specific_subgroup() |>
  tlf_ae_specific_subgroup(
    meddra_version = "24.0",
    source = "Source:  [CDISCpilot: adam-adsl; adae]",
    path_outtable = tempfile(fileext = ".rtf")
  )
}
