% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{create_simulation}
\alias{create_simulation}
\title{Create a simulation}
\usage{
create_simulation(source_environment, ID = NULL, seed = NULL)
}
\arguments{
\item{source_environment}{\verb{<SpatRasterDataset>} created by \code{\link[terra:sds]{terra::sds()}} that represents the environment.
The individual data sets represent different environmental variables
(e.g. temperature or habitat availability) and the different layer of the data sets
represent the different timesteps of the simulation.
The function \link{metaRangeSimulation}\verb{$set_time_layer_mapping()} can be used
to extend/ shorten the simulation timesteps and set the mapping between each time step and a corresponding
environmental layer. This can be used e.g. to repeat the first (few) layer as a burn-in period.
The number of layers must be the same for all data sets.}

\item{ID}{\verb{<string>} optional simulation identification string.
Will be set automatically if none is specified.}

\item{seed}{\verb{<integer>} optional seed for the random number generator.
Will be set automatically if none is specified.}
}
\value{
A \link{metaRangeSimulation} object
}
\description{
Creates a \link{metaRangeSimulation} object.
A convenience wrapper for \code{metaRangeSimulation$new()}.
}
\examples{
sim_env <- terra::sds(terra::rast(vals = 1, nrow = 2, ncol = 2))
names(sim_env) <- "env_01"
test_sim <- create_simulation(sim_env)
}
