% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/messy_dates.R
\name{messy_datetime_tzones}
\alias{messy_datetime_tzones}
\title{Change the timezone of datetime columns}
\usage{
messy_datetime_tzones(data, cols = NULL, tzones = OlsonNames(), force = FALSE)
}
\arguments{
\item{data}{input dataframe}

\item{cols}{set of columns to apply transformation to. If \code{NULL} will apply
to all POSIXt columns.}

\item{tzones}{Valid time zones to sample from. By default samples from all
\code{\link[=OlsonNames]{OlsonNames()}}, but can be set to options more relevant to the data.}

\item{force}{By default (\code{force = FALSE}) the datetimes will have their
actual hour/minute values changed along with the timezones. If \code{force = TRUE}, which requires \link[lubridate:force_tz]{lubridate}, the datetime values
will remain the same and only the timezone will differ.}
}
\value{
a dataframe the same size as the input data.
}
\description{
Takes any number of datetime columns and changes their timezones either
totally at random, or from a user-provided list of timezones.
}
\examples{
data <- data.frame(dates = rep(Sys.time(), 10))

data$dates
attr(data$dates, "tzone")

messy <- messy_datetime_tzones(data, tzones = "Poland")
messy$dates
attr(messy$dates, "tzone")

}
\seealso{
Other Messy date(time) functions: 
\code{\link{messy_datetime_formats}()},
\code{\link{split_datetimes}()}
}
\author{
Jack Davison
}
\concept{Messy date(time) functions}
