% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simcamres.R
\name{simcamres}
\alias{simcamres}
\title{Results of SIMCA multiclass classification}
\usage{
simcamres(cres, pred.res)
}
\arguments{
\item{cres}{results of classification (class \code{classres}).}

\item{pred.res}{list with prediction results from each model (pcares objects)}
}
\value{
Returns an object (list) of class \code{simcamres} with the same fields as \code{\link{classres}}
plus extra fields for Q and T2 values and limits:

\item{c.pred}{predicted class values.}
\item{c.ref}{reference (true) class values if provided.}
\item{T2}{matrix with T2 values for each object and class.}
\item{Q}{matrix with Q values for each object and class.}
\item{T2lim}{vector with T2 statistical limits for each class.}
\item{Qlim}{vector with Q statistical limits for each class.}

The following fields are available only if reference values were provided.
\item{tp}{number of true positives.}
\item{fp}{nmber of false positives.}
\item{fn}{number of false negatives.}
\item{specificity}{specificity of predictions.}
\item{sensitivity}{sensitivity of predictions.}
}
\description{
\code{simcamres} is used to store results for SIMCA multiclass classification.
}
\details{
Class \code{simcamres} inherits all properties and methods of class \code{\link{classres}}, plus
store values necessary to visualise prediction decisions (e.g. Cooman's plot or Residuals plot).

In cotrast to \code{simcares} here only values for optimal (selected) number of components in
each individual SIMCA models are presented.

There is no need to create a \code{simcamres} object manually, it is created automatically when
make a SIMCAM model (see \code{\link{simcam}}) or apply the model to a new data (see
\code{\link{predict.simcam}}). The object can be used to show summary and plots for the results.
}
\examples{
## see examples for simcam method.

}
\seealso{
Methods for \code{simcamres} objects:
\tabular{ll}{
 \code{print.simcamres} \tab shows information about the object.\cr
 \code{summary.simcamres} \tab shows statistics for results of classification.\cr
 \code{\link{plotCooman.simcamres}} \tab makes Cooman's plot.\cr
}

Methods, inherited from \code{\link{classres}} class:
\tabular{ll}{
 \code{\link{showPredictions.classres}} \tab show table with predicted values.\cr
 \code{\link{plotPredictions.classres}} \tab makes plot with predicted values.\cr
}

Check also \code{\link{simcam}}.
}
