% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{categorize.pca}
\alias{categorize.pca}
\title{Categorize PCA results based on orthogonal and score distances.}
\usage{
\method{categorize}{pca}(obj, res = obj$res$cal, ncomp = obj$ncomp.selected, ...)
}
\arguments{
\item{obj}{object with PCA model}

\item{res}{object with PCA results}

\item{ncomp}{number of components to use for the categorization}

\item{...}{other parameters}
}
\value{
vector (factor) with results of categorization.
}
\description{
The method compares score and orthogonal distances of PCA results from \code{res} with
critical limits computed for the PCA model and categorizes the corresponding objects as
"regular", "extreme" or "outlier".
}
\details{
The method does not categorize hidden values if any.
}
