% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{autoplot.mcc}
\alias{autoplot.mcc}
\title{Auto-plot method for \code{mcc} objects}
\usage{
\method{autoplot}{mcc}(x, ...)
}
\arguments{
\item{x}{An \code{mcc} object}

\item{...}{Additional arguments passed to plot.mcc}
}
\value{
A ggplot2 object
}
\description{
Convenience function that automatically creates an appropriate plot
for \code{mcc} objects. This is called when using the base R \code{plot()} function.
}
\examples{
# Create sample data
library(dplyr)
library(ggplot2)
df <- data.frame(
  id = c(1, 2, 3, 4, 4, 4, 4, 5, 5),
  time = c(8, 1, 5, 2, 6, 7, 8, 3, 3),
  cause = c(0, 0, 2, 1, 1, 1, 0, 1, 2),
  treatment = c("Control", "Control", "Treatment", "Treatment",
                "Treatment", "Treatment", "Treatment", "Control", "Control")
) |>
  arrange(id, time)

# Calculate MCC
mcc_result <- mcc(df, "id", "time", "cause", by = "treatment")

# Use autoplot (ggplot2 style)
p <- autoplot(mcc_result)
print(p)

# Customize with ggplot2 functions
p_custom <- autoplot(mcc_result) +
  theme_classic() +
  labs(caption = "Data from hypothetical study") +
  geom_hline(yintercept = 1, linetype = "dashed", alpha = 0.5)

print(p_custom)

# Clean up
rm(df, mcc_result, p, p_custom)

}
