#' Count number of observed transitions.
#'
#' @description Given a data set in long format, for instance generated by 
#' msprep, and a transition matrix for the multi-state model, this function 
#' counts the number of observed transitions in the multi-state model and gives
#' their percentages.
#'
#' @param data A data frame in long (counting process) format such as the output
#' by prepMSM.

#' @return 

#' A list containing two tables, the first, called Frequencies, with the number
#' of observed transitions in the multi-state model occurring in msdata, the 
#' second, called Proportions, with the corresponding proportions.
#' 
#' @examples
#' library(mstate)
#' data("ebmt4") 
#' db_wide <- ebmt4
#' positions<-list(c(2, 3, 5, 6), c(4, 5, 6), c(4, 5, 6), c(5, 6), c(6), c())
#' namesStates = c("Tx", "Rec", "AE", "Rec+AE", "Rel", "Death")
#' trans<-transMatMSM(positions, namesStates)
#' timesNames = c(NA, "rec", "ae","recae", "rel", "srv")
#' status=c(NA, "rec.s", "ae.s", "recae.s", "rel.s", "srv.s")
#' db_long<-prepMSM(data=db_wide, trans, timesNames, status)
#' eventsMSM(db_long)

#' @author Gustavo Soutinho and Luis Meira-Machado.


eventsMSM<-function(data){
  
  res<- events(data)
  
  return(res)
  
}