% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gendat.R
\name{gendat}
\alias{gendat}
\title{Generate Simulated Datasets for Cox Proportional Hazards Model}
\usage{
gendat(
  type = "bin",
  dimension = 10,
  K = 30,
  n = 2,
  lambda = c(1, 2),
  b1 = c(log(2), -0.1),
  theta = 8,
  censrate = 0.3
)
}
\arguments{
\item{type}{Character. If \code{type = 'bin'}, the covariates are generated as  binary variables; if \code{type = 'cont'}  continuous covariates are generated.}

\item{dimension}{Integer. The number of datasets to be generated.}

\item{K}{Integer. The number of clusters (groups) within each dataset.}

\item{n}{Integer. The number of samples within each cluster.}

\item{lambda}{Numeric vector. A two-element vector specifying the parameters for the baseline distribution:
\itemize{
\item If \code{lambda = c(a, b)}, where \code{a > 1}, the baseline follows a Weibull distribution.
\item If \code{lambda = c(1, b)}, the baseline follows an exponential distribution.
}}

\item{b1}{Vector. The regression coefficient for the covariates, affecting the hazard function. We suggest that the maximum of \code{b1} should be lower than 2.}

\item{theta}{Numeric. A parameter controlling the dependency structure between survival times within clusters.
Higher values indicate stronger within-cluster correlation.}

\item{censrate}{Numeric. The target censoring rate for the dataset.}
}
\value{
A list containing:
\itemize{
\item \code{data} - A list of data frames, each containing a generated dataset.
\item \code{censoringrates} - A numeric vector representing the censoring rate for each dataset.
\item \code{mean(censoringrates)} - The mean censoring rate across all datasets.
}
}
\description{
This function generates multiple datasets for survival analysis based on a Cox proportional hazards model.
The baseline hazard function follows either a Weibull or an exponential distribution, depending on the values of \code{lambda}.
The function ensures that the maximum observed time in both the control and treatment groups is checked for censoring.
If the maximum time is not censored, it is forced to be censored to maintain the desired censoring rate.
}
\examples{
# Generate binary covariate datasets with 1 datasets, 10 clusters, and 6 samples per cluster
print(gendat(type = 'bin', dimension = 1, K = 6, n = 10, lambda = c(1, 2),
      b1 = c(log(2),-log(2)), theta = 8, censrate = 0.5))
}
