% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_shift.R
\name{simulate_shift}
\alias{simulate_shift}
\title{Simulate MOUF process}
\usage{
simulate_shift(T, tau = NULL, mu, A)
}
\arguments{
\item{T}{time}

\item{tau}{variance parameters - named vector with 'tau.z' and 'tau.v'}

\item{mu}{mean vector - typically output of \code{\link{getMu}}. Can also be any complex or a two-column matrix, or a multi-column matrix with some named columns "x" and "y" (case-insensitive)).}

\item{A}{95\% area parameter}
}
\value{
a data frame with Time, X, and Y columns.
}
\description{
Simulate MOUF process
}
\examples{
require(marcher)

# 95\% home range area
A <- 20
# distance of migration
D <- 100
# centers of attraction
x1 <- 0; y1 <- 0
x2 <- sqrt(D); y2 <- sqrt(D)
# time scales
tau.z <- 5
tau.v <- 0.5

t1 <- 90
dt <- 20

# mean parameters (t1,dt)
mus <- c(t1=t1,dt=dt,x1=x1,y1=y1,x2=x2,y2=y2)
# time-scale parameters
taus <- c(tau.z = tau.z, tau.v = tau.v)

# generate and plot mean vector
T <- 1:200
Mu <- getMu(T, mus)

# simulate and plot MOUF process
SimTrack <- simulate_shift(T, tau=taus, Mu, A=A)
with(SimTrack, scan_track(time=T,x=X,y=Y))
}
\seealso{
\code{\link{getMu}}
}
