% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xytb-class.R
\name{resRF}
\alias{resRF}
\title{Random forest model outputs for a xytb object}
\usage{
resRF(xytb, type = "rf")
}
\arguments{
\item{xytb}{An xytb object with a model.}

\item{type}{\itemize{
  \item \code{rf}: plot of the OOB versus the number of trees (see \link[randomForest]{randomForest}).
  \item \code{importance}: importance plot (see \link[randomForest]{varImpPlot}).
  \item \code{rfcv}: plot of the cross-validated prediction performance of models
with sequentially reduced number of predictors (see \link[randomForest]{rfcv}).
  \item \code{confusion}: confusion matrix between observed and predicted behaviours (see \link[caret]{confusionMatrix}).
}}
}
\value{
plots or tables.
}
\description{
Diagnostic plots and tables for the random forest model used to predict behaviour on a
xytb objecti (random forest convergence plot, variable importance plot,
cross-validation plot, confusion matrix of the observed vs predicted
behaviours).
}
\examples{
\dontrun{ 
#track_CAGA_005 is dataset
#generate a complete xytb object with derived (over moving windows of 3, 5
#and 9 points, with quantile at 0, 50 and 100\%) and shifted information on 10
#and 100 points
xytb<-xytb(track_CAGA_005,"a track",c(3,5,9),c(0,.5,1),c(10,100))
#compute a random forest model to predict behaviour (b, where -1 is
#unobserved behaviour) using the derived
#parameters ("actual")
xytb<-modelRF(xytb,"actual",nob="-1",colin=TRUE,varkeep=c("v","thetarel"),
zerovar=TRUE,rfcv=TRUE,step=.9)
#modelling results
resRF(xytb,type="rf")
resRF(xytb,type="importance")
resRF(xytb,type="rfcv")
resRF(xytb,type="confusion")
}
}
\seealso{
See \link[randomForest]{randomForest}
}
\author{
Laurent Dubroca
}
