% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top_level.R
\name{ltmmCombo}
\alias{ltmmCombo}
\title{Fit a Left-truncated mixture model (LTMM)}
\usage{
ltmmCombo(
  x,
  G,
  distributions = c("lognormal", "gamma", "weibull"),
  trunc = NULL,
  EM_init_method = "emEM",
  EM_starts = 5,
  init_pars = NULL,
  init_pi = NULL,
  init_classes = NULL,
  one_group_reps = 50,
  eps = 1e-06,
  max.it = 1000,
  verbose = FALSE,
  parallel = FALSE,
  cores = NULL,
  save_each_fit = FALSE
)
}
\arguments{
\item{x}{data vector}

\item{G}{number of components}

\item{distributions}{densities to combine}

\item{trunc}{left truncation point (optional)}

\item{EM_init_method}{initialization method for EM algorithm}

\item{EM_starts}{number of random starts for initialization of EM algorithm. (only for G > 1)}

\item{init_pars}{initial parameter values (list of length G)}

\item{init_pi}{manually specified initial component proportions (for init_method=specified)}

\item{init_classes}{manually specified initial classes. will overwrite init_pars and init_pi}

\item{one_group_reps}{number of random starts for each numerical optimization in 1-component model}

\item{eps}{stopping tolerance for EM algoithm}

\item{max.it}{maximum number of iterations of EM algorithm}

\item{verbose}{print information as fitting progresses?}

\item{parallel}{fit models in parallel?}

\item{cores}{number of processes used for parallel computation. if NULL detect.cores() used}

\item{save_each_fit}{save each model as it is produced, in a time-stamped directory (safer)}
}
\value{
An ltmmCombo model object, with the following properties:
\describe{
  \item{x}{Copy of the input data}
  \item{distributions}{The selected distributions}
  \item{combos}{List of all combinations of distributions considered}
  \item{all.fits}{List of all ltmm fit objects}
  \item{all.bic}{Vector of BIC values for each model}
  \item{best.bic.fit}{The best ltmm fit by BIC}
  \item{best.bic}{The best BIC value of all fits}
  \item{best.bic.combo}{The combination of distributions used for the best fit by BIC}
  \item{all.aic}{Vector of AIC value for each model}
  \item{best.aic.fit}{The best ltmm fit by AIC}
  \item{best.aic}{The best AIC value of all fits}
  \item{best.aic.combo}{The combination of distributions used for the best fit by AIC}
  \item{all.ll}{Vector of log-likelihood value for each model}
  \item{summary_table}{Table summarizing the AIC, BIC, LL, and risk measures for each fitted model}
}
}
\description{
This function fits a family of finite mixture models using every combination of the left-truncated
             lognormal, gamma, and weibull distributions.
}
\examples{
\donttest{
x <- secura$Loss

fits_GL <- ltmmCombo(x, G = 2, distributions = c('gamma', 'lognormal'), trunc = 1.2e6)
summary(fits_GL)
}

}
\references{
Blostein, Martin & Miljkovic, Tatjana. (2019). On modeling left-truncated loss data using mixtures of distributions. Insurance Mathematics and Economics. 85. 35-46. 10.1016/j.insmatheco.2018.12.001.
}
