% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ode_cpp}
\alias{ode_cpp}
\title{Ordinary differential equation solver using lsoda (C++ code)}
\usage{
ode_cpp(y, times, func, rtol = 1e-06, atol = 1e-06)
}
\arguments{
\item{y}{vector of initial state values}

\item{times}{vector of times -- including the start time}

\item{func}{R function with signature function(t,y) that returns a
list: the first list element is a vector for dy/dt; the second list
element, if it exists, is a vector of result calculations to be retained.}

\item{rtol}{double for the relative tolerance}

\item{atol}{double for the absolute tolerance}
}
\value{
a matrix for times in the first column and the state andd results values in the other columns.
}
\description{
Ordinary differential equation solver using lsoda (C++ code)
}
\examples{
  times = c(0,0.4*10^(0:10))
 y = c(1,0,0)
 func = function(t,y) {
     ydot = rep(0,3)
     ydot[1] = 1.0E4 * y[2] * y[3] - .04E0 * y[1]
     ydot[3] = 3.0E7 * y[2] * y[2]
     ydot[2] = -1.0 * (ydot[1] + ydot[3])
     list(ydot, sum(y))
 }
 lsoda::ode_cpp(y,times,func, rtol=1e-8, atol=1e-8)
}
