% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_ln_mixture_em-predict.R
\name{predict.survival_ln_mixture_em}
\alias{predict.survival_ln_mixture_em}
\title{Predict from a lognormal_em Mixture Model fitted using EM algorithm.}
\usage{
\method{predict}{survival_ln_mixture_em}(object, new_data, type, eval_time, ...)
}
\arguments{
\item{object}{A \code{survival_ln_mixture_em} object.}

\item{new_data}{A data frame or matrix of new predictors.}

\item{type}{A single character. The type of predictions to generate.
Valid options are:
\itemize{
\item \code{"survival"} for the survival probability.
\item \code{"hazard"} for the hazard theoretical hazard.
}}

\item{eval_time}{For type = "hazard" or type = "survival", the times for the distribution.}

\item{...}{Not used, but required for extensibility.}
}
\value{
A tibble of predictions. The number of rows in the tibble is guaranteed
to be the same as the number of rows in \code{new_data}.
}
\description{
Predict from a lognormal_em Mixture Model fitted using EM algorithm.
}
\note{
Categorical predictors must be converted to factors before the fit,
otherwise the predictions will fail.
}
