% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkspotterOnFile.R
\name{linkspotterOnFile}
\alias{linkspotterOnFile}
\title{Process Linkspotter on an external file}
\usage{
linkspotterOnFile(
  file,
  corMethods = c("pearson", "spearman", "kendall", "mic", "MaxNMI"),
  defaultMinCor = 0.3,
  defaultCorMethod = corMethods[length(corMethods)],
  clusteringCorMethod = corMethods[length(corMethods)],
  nbCluster = 1:9,
  printInfo = T,
  appTitle = "Linkspotter",
  htmlTop = "",
  htmlBottom = "",
  ...
)
}
\arguments{
\item{file}{the file containing a structured dataset which the bivariate correlations are to be analyzed.}

\item{corMethods}{a vector of correlation coefficients to compute. The available coefficients
are the following : \code{c("pearson","spearman","kendall","mic","distCor","MaxNMI")}. It is not
case sensitive and still work if only the beginning of the word is put (e.g. \code{pears}).}

\item{defaultMinCor}{a double between 0 and 1. It is the minimal correlation absolute value
to consider for the first graph plot.}

\item{defaultCorMethod}{a string. One of "pearson","spearman","kendall","mic", "distCor" or
"MaxNMI". It is the correlation coefficient to consider for the first graph plot.}

\item{clusteringCorMethod}{a string. One of "pearson","spearman","kendall","mic", "distCor" or
"MaxNMI". It is the correlation coefficient to consider for the variables clustering.}

\item{nbCluster}{an integer. It is the number of clusters to compute.}

\item{printInfo}{a boolean indicating whether to print on the console some information about the
dataset and the estimated computation time.}

\item{appTitle}{a string taken as the title of the user interface.}

\item{htmlTop}{a character string that enable to customize your shiny app by adding an
HTML code in the HEAD tag.}

\item{htmlBottom}{a character string that enable to customize your shiny app by adding
an HTML code at the end of the BODY tag.}

\item{...}{Further arguments to be passed to the used read.csv function.}
}
\value{
a list containing all the material enabling to analyze correlations:
\itemize{
  \item{\code{computationTime}: a string}
  \item{\code{run_it}: a shiny.appobj object enable to deploy instantly the user interface
  for a customizable visualization.}
  \item{\code{dataset}: the initial dataset}
  \item{\code{corDF}: a the correlation data.frame including values for all coefficients}
  \item{\code{corMatrices}: a list of correlation matrices}
  \item{\code{corGroups}: data.frame a data.frame list}
  \item{\code{clusteringCorMethod}: a character}
  \item{\code{defaultMinCor}: a numeric}
  \item{\code{defaultCorMethod}: a string}
  \item{\code{corMethods}: vector of strings}
}
}
\description{
This function imports an external dataset, computes its correlation matrices,
variable clustering and the customizable user interface to visualize them using a graph.
}
\examples{
# run linkspotter on iris example data
data(iris)
tmpCSV<-tempfile(fileext = '.csv')
write.csv(iris, tmpCSV, row.names = FALSE)
lsOutputIrisFromFile<-linkspotterOnFile(file=tmpCSV)
summary(lsOutputIrisFromFile)
\dontrun{
# launch the UI
lsOutputIrisFromFile$launchShiny(options=list(port=8000))
}

}
