# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Get Bayesian Back-calculation Estimates and Model Diagnostics
#' 
#' This function performs Bayesian back-calculation, imputation of missing delays, and nowcasting based on the provided data.
#' 
#' @param outcome Vector of outcomes; difference between report and onset times
#' @param days Vector of days when the report is given, aligned from the minimum report day
#' @param week Vector indicating the week of the report, assumes no change within the week
#' @param weekend Binary vector indicating if the outcome was reported during a weekend
#' @param iter Number of iterations for the Bayesian back-calculation algorithm
#' @param sigma The standard deviation for the normal distribution
#' @param maxdelay The maximum delay parameter for the negative binomial distribution
#' @param si Serial interval vector
#' @param size The size parameter for the negative binomial distribution
#' @param workerID Identifier for the parallel worker
#' @param printProgress Flag to print the progress information
#' @param cd second size parameter, unused
#' @return output A list object that contains the back-calculated estimates and model diagnostics
#' @examples
#' \donttest{
#' data("sample_onset_dates")
#' data("sample_report_dates")
#' line_list <- create_linelist(sample_report_dates, sample_onset_dates)
#' sip <- si(14, 4.29, 1.18)
#' results <- run_backnow(
#'  line_list, 
#'   MAX_ITER = as.integer(2000), 
#'   norm_sigma = 0.5, 
#'   sip = sip,
#'   NB_maxdelay = as.integer(20), 
#'   NB_size = as.integer(6), 
#'   workerID = 1, 
#'   printProgress = 1, 
#'  preCalcTime = TRUE)
#' }
#' @export
backnow_cm <- function(outcome, days, week, weekend, iter, sigma, maxdelay, si, size, workerID, printProgress, cd = NULL) {
    .Call(`_linelistBayes_backnow_cm`, outcome, days, week, weekend, iter, sigma, maxdelay, si, size, workerID, printProgress, cd)
}

#' Calculate Log-Probability Density for Negative Binomial Distribution
#'
#' This function computes the log-probability density function of the negative
#' binomial distribution, given the number of successes, the dispersion parameter,
#' and the mean of the distribution. This is useful for probabilistic models
#' where negative binomial assumptions are applicable, such as certain types of
#' count data.
#'
#' @param x A numeric value representing the number of successes, which should be
#'          a non-negative integer.
#' @param r A numeric value representing the dispersion parameter of the negative
#'          binomial distribution. A higher value indicates a distribution more tightly
#'          concentrated around the mean.
#' @param m A numeric value representing the mean of the distribution.
#' @return A numeric value representing the log-probability density function value
#'         of observing 'x' successes given the mean 'm' and dispersion 'r'.
#'         This return value is given on the log scale to facilitate calculations
#'         that involve very small probabilities.
#' @examples
#' dnb(5, 2, 10);
#' @export
dnb <- function(x, r, m) {
    .Call(`_linelistBayes_dnb`, x, r, m)
}

#' Generate Dummy Variables Matrix for Weeks and Weekends
#'
#' This function creates a matrix of dummy variables based on reported weeks and weekend indicators.
#' Each column in the resulting matrix corresponds to a specific week, except for the last column,
#' which indicates whether the date falls on a weekend. This matrix is typically used in regression
#' models where week-specific effects are to be adjusted along with the effect of weekends.
#'
#' @param week An integer vector representing the week number of each observation.
#'        Each element denotes the week during which a specific event occurred.
#' @param weekend A binary integer vector (elements being 0 or 1) indicating whether
#'        each observation corresponds to a weekend. Here, `1` indicates a weekend and `0` a weekday.
#' @return A numeric matrix where each row corresponds to an observation and each column
#'         to a week, with an additional final column for weekend indicators. The elements
#'         of the matrix are dummy variables (0 or 1); each row contains exactly one '1' in
#'         one of the first several columns corresponding to the week of the observation,
#'         and a '1' or '0' in the last column indicating weekend status.
#' @examples
#' week <- c(1, 1, 1, 2, 2, 3, 3, 3, 3, 3)
#' weekend <- c(0, 1, 0, 0, 1, 0, 0, 1, 1, 0)
#' dummy_vars <- dummy(week, weekend)
#' @export
dummy <- function(week, weekend) {
    .Call(`_linelistBayes_dummy`, week, weekend)
}

#' Locate Missing Values in a Numeric Vector
#'
#' This function identifies the indices of missing values (NA) in a given numeric vector.
#' It is useful for data cleaning and preprocessing steps where identification of missing
#' data points is required.
#'
#' @param x A numeric vector potentially containing NA values.
#'          The values can range from -infinity to infinity.
#' @return An integer vector containing the indices where NA values are found in `x`.
#'         These indices can be used directly to reference or manipulate elements in other vectors
#'         of the same length or for subsetting the original vector.
#' @examples
#' vec <- c(1, 2, NA, 4, NA, 6)
#' findmiss(vec)
#' @export
findmiss <- function(x) {
    .Call(`_linelistBayes_findmiss`, x)
}

#' Calculate Exponential of Linear Combinations
#'
#' Computes the exponential of linear combinations of beta coefficients and a matrix
#' of predictors, typically used in Poisson or logistic regression models for estimating
#' rates or probabilities. This function specifically handles the exponential transformation,
#' which is commonly used to ensure that rates or probabilities are non-negative.
#'
#' @param x12 NumericMatrix representing a matrix of predictors, where each row corresponds
#'        to an observation and columns correspond to different predictor variables (e.g., weeks and weekends).
#' @param beta NumericVector of coefficients corresponding to the predictors in `x12`.
#'        This should include coefficients for both weekly effects and potentially an additional
#'        coefficient for weekends.
#' @return NumericVector where each element is the exponential of the linear combination
#'         of the predictors and coefficients for a given observation. This vector represents
#'         the model-estimated mean values for each observation.
#' @details The function multiplies the matrix `x12` by the vector `beta` to get the linear predictors,
#'          then applies the exponential function to convert these linear predictors to a scale
#'          suitable for models where the response variable is a count or probability.
#'          This is a critical step in generalized linear models where the link function is
#'          the natural logarithm.
#' @examples
#' # Assuming x12 is a matrix with 10 observations and 3 predictors
#' # and beta is a vector of 3 coefficients
#' x12 <- matrix(rnorm(30), ncol=3)
#' beta <- c(0.1, -0.2, 0.05)
#' get_mu_vec(x12, beta)
#' @export
get_mu_vec <- function(x12, beta) {
    .Call(`_linelistBayes_get_mu_vec`, x12, beta)
}

#' Calculate Time-Varying Reproduction Number R(t)
#'
#' This function estimates the time-varying reproduction number, R(t), based on the epidemic curve and
#' serial interval distribution. R(t) is calculated for each day using a moving window approach,
#' which involves taking a segment of the epidemic curve and applying a transformation based on the
#' serial interval to estimate how many subsequent cases are generated by cases within the window.
#'
#' @param curve NumericVector representing the estimated epidemic curve with daily counts.
#'              This curve can include both back-calculated and nowcasted counts of infections.
#' @param si NumericVector representing the serial interval distribution, expressed as a vector
#'           where each element corresponds to the probability of a delay of that many days between
#'           successive cases.
#' @param size Integer specifying the size of the moving window used to calculate the mean reproduction number.
#'             This window size determines how many days are included in the calculation of R(t) at each step.
#' @return NumericVector containing the estimated mean reproduction numbers (R(t)) for each day.
#'         The length of this vector will be the length of `curve` minus `size` minus one,
#'         reflecting the fact that the last few days do not have enough data to fill the window.
#' @examples
#' # Assume curve is a numeric vector of daily case counts and si is the serial interval distribution
#' curve <- rnorm(100, mean=10, sd=3)  # example epidemic curve
#' si <- rep(0.1, 10)  # example serial interval distribution
#' size <- 6  # example size of the moving window
#' getr(curve, si, size)
#' @export
getr <- function(curve, si, size) {
    .Call(`_linelistBayes_getr`, curve, si, size)
}

#' Calculate Lambda Values for Poisson Distribution Mean
#'
#' This function computes the convolution of the epidemic curve with the serial interval distribution
#' to estimate the mean of the Poisson distribution for each day. This mean is crucial
#' in models where the number of new cases follows a Poisson process. The calculation is effectively
#' a weighted sum of past case counts, where weights are given by the serial interval distribution,
#' representing the expected number of new cases caused by an individual case on each subsequent day.
#'
#' @param curve NumericVector representing the daily counts of new cases, estimated from the epidemic data.
#'              This vector should include both historically observed data and nowcasted estimates.
#' @param si NumericVector representing the serial interval distribution, a probability distribution
#'           describing the time delay between successive cases in an infectious disease transmission chain.
#' @return NumericVector containing the estimated mean values for the Poisson distribution
#'         at each day, excluding the last day as the serial interval cannot be fully applied.
#' @details The function applies the serial interval to the epidemic curve via convolution, 
#'          essentially calculating the expected number of secondary cases generated by each primary case
#'          over the serial interval. The length of the resulting vector is one less than that of `curve`
#'          because the last day's value cannot be calculated without full serial interval data.
#' @examples
#' curve <- c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
#' si <- c(0.5, 0.3, 0.2)  # Declining probability over three days
#' lambda_values <- lambda(curve, si)
#' @export
lambda <- function(curve, si) {
    .Call(`_linelistBayes_lambda`, curve, si)
}

#' Compute Log-Likelihood for a Right-Truncated Negative Binomial Model
#'
#' This function calculates the log-likelihood of observing the given data under a 
#' right-truncated negative binomial distribution. It is used to assess the fit of 
#' a model involving delay times in reporting cases, where each case has a 
#' delay modeled by a negative binomial distribution that is truncated at a specified maximum delay.
#'
#' @param delay_vec NumericVector representing the observed delay times for each case.
#' @param x12 NumericMatrix of covariates used to model the mean of the negative binomial distribution.
#'        Each row corresponds to a case and columns correspond to covariates including time since onset and others.
#' @param disp NumericVector indicating the dispersion parameter for each case. This can affect the distribution 
#'        of counts and is used to model heterogeneity in reporting delays.
#' @param betaplus NumericVector containing current estimates of the model parameters, which may include 
#'        coefficients for covariates and additional parameters.
#' @param maxdelay Integer specifying the maximum reporting delay, truncating the distribution at this value.
#' @return Double representing the log-likelihood of the data given the model parameters. This value 
#'         measures how well the model with the current parameter estimates fits the observed data.
#' @details This function computes the log-likelihood by calculating the likelihood of each observed 
#'          delay under the specified model parameters, considering the truncation at `maxdelay`. 
#'          The parameters `disp` and `betaplus` allow for flexibility in modeling different types of 
#'          heterogeneity and covariate effects.
#' @examples
#' # Example usage with arbitrary data:
#' delay_vec <- rnorm(100, mean=10, sd=3)  # Simulated delay times
#' x12 <- matrix(rnorm(300), ncol=3)       # Simulated covariates
#' disp <- rep(1, 100)                     # Dispersion parameter, constant for simplicity
#' betaplus <- runif(4)                    # Simulated parameter estimates
#' maxdelay <- 15                          # Maximum delay for truncation
#' loglik_value <- logLikNB(delay_vec, x12, disp, betaplus, maxdelay)
#' @export
logLikNB <- function(delay_vec, x12, disp, betaplus, maxdelay) {
    .Call(`_linelistBayes_logLikNB`, delay_vec, x12, disp, betaplus, maxdelay)
}

#' Compute Cumulative Distribution Function for Negative Binomial Distribution
#'
#' This function calculates the cumulative distribution function (CDF) of the negative binomial distribution
#' given a number of successes, a dispersion parameter, and the mean. The negative binomial distribution 
#' is commonly used to model count data with overdispersion relative to a Poisson distribution.
#'
#' @param x Non-negative integer specifying the number of successes for which the CDF is computed.
#'          This value must be non-negative as it represents the number of successes in the distribution.
#' @param r Dispersion parameter of the distribution, a positive real number.
#'          Higher values of 'r' indicate a higher probability of counts clustering around the mean, reducing overdispersion.
#' @param m Mean of the distribution, a positive real number indicating the expected number of successes.
#'          The mean must be positive.
#' @return y The probability of observing up to 'x' successes in a negative binomial distribution
#'           parameterized by 'r' (dispersion) and 'm' (mean). This function returns the CDF value.
#' @details The negative binomial distribution can be parameterized by a dispersion parameter 'r' and a mean 'm',
#'          which together determine the shape of the distribution. This function is essential for modeling and
#'          probability calculations in various fields such as epidemiology and ecology where the negative binomial
#'          distribution is used to model count data.
#' @examples
#' pnb(10, 5, 10)
#' @export
pnb <- function(x, r, m) {
    .Call(`_linelistBayes_pnb`, x, r, m)
}

#' Calculate Proportions of Event Counts Within a Specified Time Range
#'
#' This function calculates the proportion of event counts that occur within each
#' unit of time from a specified starting point (onset time) up to a maximum delay.
#' The proportions are computed relative to the total number of events occurring within
#' the specified time range.
#'
#' @param x NumericVector representing the count of events at each time point.
#' @param onset NumericVector representing the onset times for each event count.
#'          Each element in the vector indicates the time at which an event was initiated.
#' @param maxdelay The maximum time delay (inclusive) for which the proportions are calculated.
#'          This parameter defines the upper bound of the time interval over which the proportions
#'          of event counts are evaluated.
#' @param cd The onset time (exclusive) from which to start calculating proportions.
#'          Events that start at times less than or equal to this value are excluded from the calculation.
#' @return NumericVector containing the proportions of the total events falling within each unit
#'         of time from the specified 'cd' up to 'maxdelay'. The proportions are cumulative,
#'         with each element representing the proportion of events that have occurred by that time point,
#'         starting from 'cd'.
#'
#' @examples
#' x <- c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
#' onset <- c(1, 1, 2, 2, 3, 3, 4, 4, 5, 5)
#' maxdelay <- 5
#' cd <- 1
#' prop(x, onset, maxdelay, cd)
#' @export
prop <- function(x, onset, maxdelay, cd) {
    .Call(`_linelistBayes_prop`, x, onset, maxdelay, cd)
}

#' Generate Random Samples from a Negative Binomial Distribution
#'
#' This function generates random samples from a negative binomial distribution with the specified dispersion parameter (\code{r}) and success probability (\code{p}).
#'
#' @param r The number of failures before achieving a specified number of successes in a negative binomial experiment. It also serves as the dispersion parameter which controls the variance of the distribution.
#' @param p The probability of success on each independent Bernoulli trial within the negative binomial experiment.
#' @return A random value sampled from the negative binomial distribution with parameters \code{r} and \code{p}.
#'
#' @examples
#' r <- 2
#' p <- 0.3
#' rnb(r, p)
#' @export
rnb <- function(r, p) {
    .Call(`_linelistBayes_rnb`, r, p)
}

