# works with co2fluxtent test files

    Code
      str(import7500(test_path("co2fluxtent/"), plotinfo = c("date", "location",
        "time_of_day", "trial")), digits.d = 4, width = 100, strict.width = "cut")
    Output
      tibble [345 x 24] (S3: tbl_df/tbl/data.frame)
       $ f_fluxid       : chr [1:345] "06172020_almont_night_1a.txt" "06172020_almont_night_1a.txt" "06"..
       $ Relative Time  : num [1:345] 0.91 1.91 2.91 3.98 4.91 5.92 6.91 7.92 8.91 9.92 ...
       $ Temperature    : num [1:345] -65.72 -65.72 -65.72 -65.73 -65.72 -66.19 -65.72 -65.72 -65.72 -65..
       $ Pressure       : num [1:345] 75.67 75.67 75.67 75.67 75.67 75.67 75.67 75.7 75.67 75.67 ...
       $ Aux Input      : num [1:345] 0 0 0 0 0 0 0 0 0 0 ...
       $ CO2 Absorptance: num [1:345] 0.0752 0.0731 0.0737 0.0731 0.073 0.0729 0.0733 0.0733 0.0729 0.07..
       $ CO2 mmol/m3    : num [1:345] 14.06 13.89 14.06 13.47 13.51 13.42 13.46 13.47 13.43 13.41 ...
       $ CO2 mg/m3      : num [1:345] 618.7 611.3 618.6 592.7 594.6 590.7 592.4 592.5 590.8 590 ...
       $ CO2 umol/mol   : num [1:345] 320.5 316.6 320.4 307 308 ...
       $ H2O Absorptance: num [1:345] 0.0163 0.0163 0.0165 0.0167 0.0166 0.0167 0.0168 0.0169 0.0169 0.0..
       $ H2O mmol/m3    : num [1:345] 96 96.1 97.5 97 97.4 97.1 98 98.7 98.7 98.7 ...
       $ H2O g/m3       : num [1:345] 1.728 1.731 1.756 1.747 1.754 1.748 1.764 1.777 1.776 1.777 ...
       $ H2O mmol/mol   : num [1:345] 2.19 2.19 2.22 2.21 2.22 2.21 2.23 2.25 2.25 2.25 ...
       $ H2O(°C)        : num [1:345] -16.78 -16.76 -16.59 -16.65 -16.61 -16.67 -16.54 -16.45 -16.46 -16..
       $ Cooler Voltage : num [1:345] 1.44 1.44 1.44 1.44 1.44 1.44 1.44 1.44 1.44 1.44 ...
       $ f_datetime     : POSIXct[1:345], format: "2020-06-17 20:22:07" "2020-06-17 20:22:08" "2020-06-"..
       $ comment        : chr [1:345] NA NA NA NA ...
       $ f_start        : POSIXct[1:345], format: "2020-06-17 20:22:07" "2020-06-17 20:22:07" "2020-06-"..
       $ f_end          : POSIXct[1:345], format: "2020-06-17 20:23:06" "2020-06-17 20:23:06" "2020-06-"..
       $ pressure_atm   : num [1:345] 0.7468 0.7468 0.7468 0.7468 0.7468 ...
       $ date           : chr [1:345] "06172020" "06172020" "06172020" "06172020" ...
       $ location       : chr [1:345] "almont" "almont" "almont" "almont" ...
       $ time_of_day    : chr [1:345] "night" "night" "night" "night" ...
       $ trial          : chr [1:345] "1a" "1a" "1a" "1a" ...

# works with pftc5 test files

    Code
      str(import7500(test_path("pftc5/"), plotinfo = c("site", "block", "date",
        "plot", "trial")), digits.d = 4, width = 100, strict.width = "cut")
    Output
      tibble [287 x 25] (S3: tbl_df/tbl/data.frame)
       $ f_fluxid       : chr [1:287] "ACJ_B_15mar2018_plot1_a.txt" "ACJ_B_15mar2018_plot1_a.txt" "ACJ_"..
       $ Relative Time  : num [1:287] 0.88 1.94 2.88 3.94 4.86 5.88 6.86 7.88 8.86 9.88 ...
       $ Temperature    : num [1:287] 20.94 20.92 20.92 20.94 20.94 20.92 20.94 20.94 20.94 20.94 ...
       $ Pressure       : num [1:287] 67.88 NA 67.86 67.86 67.86 67.86 67.86 67.86 67.89 67.89 ...
       $ Aux Input      : num [1:287] 0 0 0 0 0 0 0 0 0 0 ...
       $ CO2 Absorptance: num [1:287] 0.0638 0.0637 0.0633 0.063 0.063 0.063 0.0632 0.0625 0.063 0.063 ...
       $ CO2 mmol/m3    : num [1:287] 11.71 11.69 11.58 11.43 11.47 11.44 11.57 11.43 11.46 11.47 ...
       $ CO2 mg/m3      : num [1:287] 515.4 514.6 509.7 503.1 504.8 503.2 509 502.7 504.4 504.6 ...
       $ CO2 umol/mol   : num [1:287] 421.9 421.3 417.3 412 413.4 ...
       $ H2O Absorptance: num [1:287] 0.06 0.0604 0.0605 0.0617 0.0608 0.0613 0.0599 0.0637 0.0617 0.061..
       $ H2O mmol/m3    : num [1:287] 491.6 483.3 489.5 514.4 502.2 518.8 478.8 506.5 517.7 510.6 ...
       $ H2O g/m3       : num [1:287] 8.848 8.699 8.811 9.26 9.039 9.338 8.619 9.116 9.319 9.19 ...
       $ H2O mmol/mol   : num [1:287] 17.7 17.41 17.64 18.54 18.09 18.69 17.25 18.25 18.65 18.39 ...
       $ H2O(°C)        : num [1:287] 9.62 9.37 9.56 10.3 9.94 10.43 9.24 10.07 10.4 10.19 ...
       $ Cooler Voltage : num [1:287] 1.48 1.48 1.48 1.48 1.48 1.48 1.48 1.48 1.48 1.48 ...
       $ f_datetime     : POSIXct[1:287], format: "2018-03-15 07:39:19" "2018-03-15 07:39:20" "2018-03-"..
       $ comment        : chr [1:287] "Clear, high PAR, light wind" "Clear, high PAR, light wind" "Clea"..
       $ f_start        : POSIXct[1:287], format: "2018-03-15 07:39:19" "2018-03-15 07:39:19" "2018-03-"..
       $ f_end          : POSIXct[1:287], format: "2018-03-15 07:39:48" "2018-03-15 07:39:48" "2018-03-"..
       $ pressure_atm   : num [1:287] 0.6699 NA 0.6697 0.6697 0.6697 ...
       $ site           : chr [1:287] "ACJ" "ACJ" "ACJ" "ACJ" ...
       $ block          : chr [1:287] "B" "B" "B" "B" ...
       $ date           : chr [1:287] "15mar2018" "15mar2018" "15mar2018" "15mar2018" ...
       $ plot           : chr [1:287] "plot1" "plot1" "plot1" "plot1" ...
       $ trial          : chr [1:287] "a" "a" "a" "a" ...

# works with pftc7 test files

    Code
      str(import7500(test_path("pftc7/"), version = "post2023", plotinfo = FALSE),
      digits.d = 4, width = 100, strict.width = "cut")
    Output
      tibble [330 x 42] (S3: tbl_df/tbl/data.frame)
       $ f_fluxid                  : chr [1:330] "1_2000_east_1_day_a-2023-12-14T105700.txt" "1_2000_ea"..
       $ DATAH                     : chr [1:330] "DATA" "DATA" "DATA" "DATA" ...
       $ Time                      : chr [1:330] "10:57:01" "10:57:02" "10:57:03" "10:57:04" ...
       $ Date                      : Date[1:330], format: "2023-12-14" "2023-12-14" "2023-12-14" ...
       $ Sequence Number           : num [1:330] 123540 123840 124140 124440 124740 ...
       $ CO2 (mmol/m^3)            : num [1:330] 13.56 13.28 13.18 13.72 13.42 ...
       $ CO2 (mg/m^3)              : num [1:330] 596.6 584.3 579.8 603.7 590.3 ...
       $ CO2 Absorptance           : num [1:330] 0.09824 0.09667 0.0961 0.09913 0.09743 ...
       $ CO2 (umol/mol)            : num [1:330] 416 407.3 404.2 420.8 411.5 ...
       $ H2O (mmol/m^3)            : num [1:330] 740.2 732.2 750.1 736.1 742.2 ...
       $ H2O (g/m^3)               : num [1:330] 13.32 13.18 13.5 13.25 13.36 ...
       $ H2O Absorptance           : num [1:330] 0.07404 0.07348 0.07473 0.07375 0.07418 ...
       $ H2O (mmol/mol)            : num [1:330] 22.71 22.46 23.01 22.58 22.76 ...
       $ Dew Point (C)             : num [1:330] 15.95 15.78 16.15 15.86 15.99 ...
       $ Temperature (C)           : num [1:330] 22.37 22.36 22.35 22.34 22.34 ...
       $ Pressure (kPa)            : num [1:330] 80.09 NA 80.09 80.1 80.1 ...
       $ Diagnostic Value          : num [1:330] 255 255 255 255 255 255 255 255 255 255 ...
       $ Diagnostic Value 2        : num [1:330] 0 0 0 0 0 0 0 0 0 0 ...
       $ Diagnostic Word           : num [1:330] 0 0 0 0 0 0 0 0 0 0 ...
       $ DSI Vin (v)               : num [1:330] 13.08 13.08 13.08 13.08 13.08 ...
       $ Cooler Voltage (v)        : num [1:330] 2.023 2.023 2.023 2.023 2.023 ...
       $ Chopper Cooler Voltage (v): num [1:330] 2.329 2.328 2.329 2.329 2.328 ...
       $ Smart Flux Vin (v)        : num [1:330] 13.2 13.2 13.2 13.2 13.2 13.2 13.2 13.2 13.2 13.2 ...
       $ CO2 Signal Strength       : num [1:330] 99.5 99.5 99.51 99.51 99.5 ...
       $ Integral                  : num [1:330] 0 0 0 0 0 0 0 0 0 0 ...
       $ Peak Height               : num [1:330] 0 0 0 0 0 0 0 0 0 0 ...
       $ CO2 Sample                : num [1:330] 34486 34630 34645 34504 34617 ...
       $ CO2 Reference             : num [1:330] 43966 43968 43966 43968 43966 ...
       $ H2O Sample                : num [1:330] 49056 49036 49030 49085 48993 ...
       $ H2O Reference             : num [1:330] 52779 52780 52778 52782 52773 ...
       $ CH4 Seconds               : num [1:330] 0 0 0 0 0 0 0 0 0 0 ...
       $ CH4 Nano Seconds          : num [1:330] 0 0 0 0 0 0 0 0 0 0 ...
       $ CH4 (umol/mol)            : num [1:330] 0 0 0 0 0 0 0 0 0 0 ...
       $ CH4 (mmol/m^3)            : num [1:330] 0 0 0 0 0 0 0 0 0 0 ...
       $ CH4 Signal Strength (RSSI): num [1:330] 0 0 0 0 0 0 0 0 0 0 ...
       $ CH4 Diagnostic Value      : num [1:330] 0 0 0 0 0 0 0 0 0 0 ...
       $ CHK                       : num [1:330] 10 163 64 252 4 17 96 47 82 44 ...
       $ f_datetime                : POSIXct[1:330], format: "2023-12-14 10:57:01" "2023-12-14 10:57:02"..
       $ comment                   : chr [1:330] NA NA NA NA ...
       $ f_start                   : POSIXct[1:330], format: "2023-12-14 10:57:01" "2023-12-14 10:57:01"..
       $ f_end                     : POSIXct[1:330], format: "2023-12-14 10:58:48" "2023-12-14 10:58:48"..
       $ pressure_atm              : num [1:330] 0.7905 NA 0.7905 0.7905 0.7905 ...

