% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libname.R
\name{lib_info}
\alias{lib_info}
\title{Get Information about a Data Library}
\usage{
lib_info(x)
}
\arguments{
\item{x}{The data library.}
}
\value{
A data frame of information about the library.
}
\description{
The \code{lib_info} function returns a data frame of information
about each item in the data library.  That information includes the item
name, file extension, number of rows, number of columns, size in bytes, 
and the last modified date.
}
\examples{
# Create temp directory
tmp <- tempdir()

# Create data library
libname(dat, tmp)

# Add data to library
lib_add(dat, trees, rock, beaver1)

# Get library information
info <- lib_info(dat)

# Examine info
info
#      Name Extension Rows Cols   Size        LastModified
# 1 beaver1       rds  114    4 5.3 Kb 2020-11-05 21:27:57
# 2   rocks       rds   48    4 3.1 Kb 2020-11-05 21:27:56
# 3   trees       rds   31    3 2.4 Kb 2020-11-05 21:27:56

# Clean up
lib_delete(dat)
}
\seealso{
Other lib: 
\code{\link{is.lib}()},
\code{\link{lib_add}()},
\code{\link{lib_copy}()},
\code{\link{lib_delete}()},
\code{\link{lib_export}()},
\code{\link{lib_load}()},
\code{\link{lib_path}()},
\code{\link{lib_remove}()},
\code{\link{lib_replace}()},
\code{\link{lib_size}()},
\code{\link{lib_sync}()},
\code{\link{lib_unload}()},
\code{\link{lib_write}()},
\code{\link{libname}()},
\code{\link{print.lib}()}
}
\concept{lib}
