% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{take_interaction_2ndderivative}
\alias{take_interaction_2ndderivative}
\title{Calculate Second Derivatives of Interaction Terms}
\usage{
take_interaction_2ndderivative(
  dat,
  var,
  interaction_single_cols,
  interaction_quad_cols,
  triplet_cols,
  colnm_expansions,
  power1_cols,
  power2_cols
)
}
\arguments{
\item{dat}{Numeric matrix; design matrix containing basis expansions}

\item{var}{Character; variable name to differentiate with respect to}

\item{interaction_single_cols}{Integer vector; column indices for linear-linear interactions}

\item{interaction_quad_cols}{Integer vector; column indices for linear-quadratic interactions}

\item{triplet_cols}{Integer vector; column indices for three-way interactions}

\item{colnm_expansions}{Character vector; column names of expansions for each partition}

\item{power1_cols}{Integer vector; column indices of linear terms}

\item{power2_cols}{Integer vector; column indices of quadratic terms}
}
\value{
Numeric matrix of second derivatives, same dimensions as input
}
\description{
Computes partial second derivatives for interaction terms including
two-way linear, quadratic, and three-way interactions. Handles special cases
for each type.

This function is necessary to compute total second derivatives as the sum of
second partial "pure" derivatives (\eqn{d^2/dx^2}) plus second partial "mixed"
derivative (\eqn{d^2/dxdz}), for a predictor x and all other predictors z.
}
\keyword{internal}
