% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varianceMap.R
\name{varianceMap}
\alias{varianceMap}
\title{Spatial variance for the regression smoother.}
\usage{
varianceMap(formLatticeOutput, Z, PointPattern, M = 0.5, k)
}
\arguments{
\item{formLatticeOutput}{An object from formLattice or editLattice.}

\item{Z}{Vector of response values.}

\item{PointPattern}{2-column matrix or data frame of locations.}

\item{M}{Maximum probability that the random walk moves.}

\item{k}{Number of steps in random walk.}
}
\value{
VarianceMapOut object
\itemize{
  \item EW_locs EW coordinates for use by contour
  \item NS_locs NS coordinates for use by contour
  \item boundaryPoly vertices of the boundary
  \item hole_list list of polygonal hole boundaries, if any.
  \item SE_map_grid estimated standard error at each location}
}
\description{
Computes the variance at each location for the 
non-parametric regression estimator.
}
\details{
\code{varianceMap} computes an estimated variance at each
node in the lattice, output in a form for mapping with contour.
The approach is the Nadaraya-Watson kernel variance estimator:
\eqn{s^2\sum K^2(si,s0)/(\sum K(si,s0))^2}.  It's important to note
that this should not be overused as a prediction error, as kernel
estimators are not unbiased.
}
\examples{
data(nparExample)
attach(nparExample)
plot.new()
#  Simulate a response variable
index1 <- (grid2[,2]<0.8)|(grid2[,1]>0.6)
Z <- rep(NA,length(grid2[,1]))
n1 <- sum(index1)
n2 <- sum(!index1)
Z[index1] <- 3*grid2[index1,1] + 4 + rnorm(n1,0,sd=0.4)
Z[!index1] <- -2*grid2[!index1,1] + 4 + rnorm(n2,0,sd=0.4)
#
plot(polygon2,type="n")

polygon(polygon2)
points(grid2,pch=19,cex=0.5,xlim=c(-0.1,1))
text(grid2,labels=round(Z,1),pos=4,cex=0.5)
#
nodeFillingOutput <- nodeFilling(poly=polygon2, node_spacing=0.025)
plot(nodeFillingOutput)
formLatticeOutput <- formLattice(nodeFillingOutput)
plot(formLatticeOutput)
hold <- crossvalNparReg(formLatticeOutput,Z,
                       PointPattern=grid2,M=0.5,max_steps = 20)
var_map <- varianceMap(formLatticeOutput,Z,
             PointPattern=grid2,M=0.5,k=10)
plot(var_map)

}
\references{
Ronald P. Barry, Julie McIntyre. Estimating 
animal densities and home range in regions 
with irregular boundaries and holes: A 
lattice-based alternative to the kernel 
density estimator. Ecological Modelling 222 (2011) 1666-1672.
<doi:10.1016/j.ecolmodel.2011.02.016>

Julie McIntyre, Ronald P. Barry (2018)  A Lattice-Based 
Smoother for Regions with Irregular Boundaries and Holes.  
Journal of Computational and Graphical Statistics.  In Press.
}
\author{
Ronald P. Barry
}
