% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_plots.R
\name{mplot_metrics}
\alias{mplot_metrics}
\title{Model Metrics and Performance Plots}
\usage{
mplot_metrics(
  results,
  subtitle = NA,
  model_name = NA,
  save = FALSE,
  subdir = NA,
  file_name = "viz_metrics.png"
)
}
\arguments{
\item{results}{Object. Results object from h2o_automl function}

\item{subtitle}{Character. Subtitle to show in plot}

\item{model_name}{Character. Model's name}

\item{save}{Boolean. Save output plot into working directory}

\item{subdir}{Character. Sub directory on which you wish to save the plot}

\item{file_name}{Character. File name as you wish to save the plot}
}
\value{
Plot with \code{results} performance.
}
\description{
This function generates plots of the metrics of a predictive model.
This is an auxiliary function used in \code{model_metrics()} when
the parameter \code{plot} is set to \code{TRUE}.
}
\seealso{
Other ML Visualization: 
\code{\link{mplot_conf}()},
\code{\link{mplot_cuts}()},
\code{\link{mplot_cuts_error}()},
\code{\link{mplot_density}()},
\code{\link{mplot_full}()},
\code{\link{mplot_gain}()},
\code{\link{mplot_importance}()},
\code{\link{mplot_lineal}()},
\code{\link{mplot_response}()},
\code{\link{mplot_roc}()},
\code{\link{mplot_splits}()},
\code{\link{mplot_topcats}()}
}
\concept{ML Visualization}
